/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.InvalidDataException;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class ClusteringBased
extends MultiLabelMetaLearner {
    private int numClusters;
    private MultiLabelLearner[] multi;
    private Clusterer clusterer;

    public ClusteringBased() {
        super(new LabelPowerset((Classifier)new J48()));
        try {
            SimpleKMeans kmeans = new SimpleKMeans();
            kmeans.setNumClusters(5);
            kmeans.setDistanceFunction((DistanceFunction)new EuclideanDistance());
            this.clusterer = kmeans;
        }
        catch (Exception ex) {
            Logger.getLogger(ClusteringBased.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public ClusteringBased(Clusterer aClusterer, MultiLabelLearner aMultiLabelClassifier) {
        super(aMultiLabelClassifier);
        this.clusterer = aClusterer;
    }

    public Clusterer getClusterer() {
        return this.clusterer;
    }

    @Override
    public void buildInternal(MultiLabelInstances trainData) throws Exception {
        int i;
        Instances trainInstances = trainData.getDataSet();
        Instances removedInstances = RemoveAllLabels.transformInstances(trainData);
        this.clusterer.buildClusterer(removedInstances);
        this.numClusters = this.clusterer.numberOfClusters();
        MultiLabelInstances[] subsetMultiLabelInstances = new MultiLabelInstances[this.numClusters];
        Instances[] subsetInstances = new Instances[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            subsetInstances[i] = new Instances(trainInstances, 0);
            subsetMultiLabelInstances[i] = new MultiLabelInstances(subsetInstances[i], trainData.getLabelsMetaData());
        }
        for (i = 0; i < trainInstances.numInstances(); ++i) {
            int clusterOfInstance = this.clusterer.clusterInstance(removedInstances.instance(i));
            subsetMultiLabelInstances[clusterOfInstance].getDataSet().add(trainInstances.instance(i));
        }
        this.multi = new MultiLabelLearner[this.numClusters];
        for (i = 0; i < this.numClusters; ++i) {
            try {
                this.multi[i] = this.baseLearner.makeCopy();
                this.debug("Dataset " + (i + 1) + ": " + subsetMultiLabelInstances[i].getDataSet().numInstances() + " instances");
                this.multi[i].build(subsetMultiLabelInstances[i]);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(ClusteringBased.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception, InvalidDataException {
        Instance newInstance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
        int cluster = this.clusterer.clusterInstance(newInstance);
        return this.multi[cluster].makePrediction(instance);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Gulisong Nasierding, Grigorios Tsoumakas, Abbas Kouzani");
        result.setValue(TechnicalInformation.Field.TITLE, "Clustering Based Multi-Label Classification for Image Annotation and Retrieval");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. 2009 IEEE International Conference on Systems, Man, and Cybernetics (SMC 2009)");
        result.setValue(TechnicalInformation.Field.LOCATION, "Texas, USA");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class implementing clustering-based multi-label classification. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

