/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.HMCNode;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.DataUtils;
import mulan.data.InvalidDataFormatException;
import mulan.data.LabelNode;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsMetaData;
import mulan.data.LabelsMetaDataImpl;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class HMC
extends MultiLabelMetaLearner {
    private LabelsMetaData originalMetaData;
    private HMCNode root;
    private Map<String, Integer> labelsAndIndices;
    private long NoNodes = 0L;
    private long NoClassifierEvals = 0L;
    private long TotalUsedTrainInsts = 0L;

    public HMC() {
        this(new BinaryRelevance((Classifier)new J48()));
    }

    public HMC(MultiLabelLearner baseLearner) {
        super(baseLearner);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Grigorios Tsoumakas and Ioannis Katakis and Ioannis Vlahavas");
        result.setValue(TechnicalInformation.Field.TITLE, "Effective and Efficient Multilabel Classification in Domains with Large Number of Labels");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. ECML/PKDD 2008 Workshop on Mining Multidimensional Data (MMD'08)");
        result.setValue(TechnicalInformation.Field.LOCATION, "Antwerp, Belgium");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    private void buildRec(HMCNode node, Instances data) throws InvalidDataFormatException, Exception {
        Set<String> currentlyAvailableLabels;
        String metaLabel = node.getName();
        HashSet<String> childrenLabels = new HashSet<String>();
        if (metaLabel.equals("root")) {
            for (LabelNode child : this.originalMetaData.getRootLabels()) {
                childrenLabels.add(child.getName());
            }
            currentlyAvailableLabels = this.originalMetaData.getLabelNames();
        } else {
            LabelNode labelNode = this.originalMetaData.getLabelNode(metaLabel);
            for (LabelNode child : labelNode.getChildren()) {
                childrenLabels.add(child.getName());
            }
            currentlyAvailableLabels = labelNode.getDescendantLabels();
        }
        HashSet<String> labelsToDelete = new HashSet<String>(currentlyAvailableLabels);
        labelsToDelete.removeAll(childrenLabels);
        int[] indicesToDelete = new int[labelsToDelete.size()];
        int counter1 = 0;
        for (String label : labelsToDelete) {
            indicesToDelete[counter1] = data.attribute(label).index();
            ++counter1;
        }
        Remove filter1 = new Remove();
        filter1.setAttributeIndicesArray(indicesToDelete);
        filter1.setInputFormat(data);
        Instances nodeInstances = Filter.useFilter((Instances)data, (Filter)filter1);
        LabelsMetaDataImpl nodeMetaData = new LabelsMetaDataImpl();
        for (String label : childrenLabels) {
            nodeMetaData.addRootNode(new LabelNodeImpl(label));
        }
        MultiLabelInstances nodeData = new MultiLabelInstances(nodeInstances, nodeMetaData);
        node.build(nodeData);
        this.TotalUsedTrainInsts += (long)nodeInstances.numInstances();
        ++this.NoNodes;
        for (String childLabel : childrenLabels) {
            LabelNode childNode = this.originalMetaData.getLabelNode(childLabel);
            if (!childNode.hasChildren()) continue;
            int childMetaLabelIndex = data.attribute(childLabel).index();
            Instances childData = new Instances(data);
            for (int i = 0; i < childData.numInstances(); ++i) {
                if (!childData.instance(i).stringValue(childMetaLabelIndex).equals("0")) continue;
                childData.delete(i);
                --i;
            }
            Set<String> descendantLabels = childNode.getDescendantLabels();
            HashSet<String> labelsToDelete2 = new HashSet<String>(currentlyAvailableLabels);
            labelsToDelete2.removeAll(descendantLabels);
            int[] indicesToDelete2 = new int[labelsToDelete2.size()];
            int counter2 = 0;
            for (String label : labelsToDelete2) {
                indicesToDelete2[counter2] = childData.attribute(label).index();
                ++counter2;
            }
            Remove filter2 = new Remove();
            filter2.setAttributeIndicesArray(indicesToDelete2);
            filter2.setInputFormat(childData);
            childData = Filter.useFilter((Instances)childData, (Filter)filter2);
            MultiLabelLearner mll = this.baseLearner.makeCopy();
            HMCNode child = new HMCNode(childLabel, mll);
            node.addChild(child);
            this.buildRec(child, childData);
        }
    }

    @Override
    protected void buildInternal(MultiLabelInstances dataSet) throws Exception {
        this.originalMetaData = dataSet.getLabelsMetaData();
        HashSet<String> rootLabels = new HashSet<String>();
        for (LabelNode node : this.originalMetaData.getRootLabels()) {
            rootLabels.add(node.getName());
        }
        MultiLabelLearner mll = this.baseLearner.makeCopy();
        this.root = new HMCNode("root", mll);
        this.buildRec(this.root, dataSet.getDataSet());
        this.labelsAndIndices = dataSet.getLabelsOrder();
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        boolean[] predictedLabels = new boolean[this.numLabels];
        double[] confidences = new double[this.numLabels];
        this.makePrediction(this.root, instance, predictedLabels, confidences);
        return new MultiLabelOutput(predictedLabels, confidences);
    }

    private void makePrediction(HMCNode currentNode, Instance instance, boolean[] predictedLabels, double[] confidences) throws Exception {
        double[] values = instance.toDoubleArray();
        Instance transformed = DataUtils.createInstance(instance, 1.0, values);
        int[] currentNodeLabelIndices = currentNode.getLabelIndices();
        HashSet<Integer> indicesToKeep = new HashSet<Integer>();
        for (int i = 0; i < currentNodeLabelIndices.length; ++i) {
            String labelToKeep = currentNode.getHeader().attribute(currentNodeLabelIndices[i]).name();
            indicesToKeep.add(this.labelIndices[this.labelsAndIndices.get(labelToKeep)]);
        }
        if (this.labelIndices.length - indicesToKeep.size() != 0) {
            int[] indicesToDelete = new int[this.labelIndices.length - indicesToKeep.size()];
            int counter = 0;
            for (int i = 0; i < this.labelIndices.length; ++i) {
                if (indicesToKeep.contains(this.labelIndices[i])) continue;
                indicesToDelete[counter] = this.labelIndices[i];
                ++counter;
            }
            transformed = RemoveAllLabels.transformInstance(transformed, indicesToDelete);
        }
        transformed.setDataset(currentNode.getHeader());
        ++this.NoClassifierEvals;
        MultiLabelOutput pred = currentNode.makePrediction(transformed);
        int[] indices = currentNode.getLabelIndices();
        boolean[] temp = pred.getBipartition();
        for (int i = 0; i < temp.length; ++i) {
            String childName = currentNode.getHeader().attribute(indices[i]).name();
            int idx = this.labelsAndIndices.get(childName);
            if (pred.getBipartition()[i]) {
                predictedLabels[idx] = true;
                confidences[idx] = pred.getConfidences()[i];
                if (!currentNode.hasChildren()) continue;
                for (HMCNode child : currentNode.getChildren()) {
                    if (!child.getName().equals(childName)) continue;
                    this.makePrediction(child, instance, predictedLabels, confidences);
                }
                continue;
            }
            predictedLabels[idx] = false;
            Set<String> descendantLabels = this.originalMetaData.getLabelNode(childName).getDescendantLabels();
            if (descendantLabels == null) continue;
            for (String label : descendantLabels) {
                int idx2 = this.labelsAndIndices.get(label);
                predictedLabels[idx2] = false;
                confidences[idx2] = pred.getConfidences()[i];
            }
        }
    }

    protected MultiLabelInstances deleteLabels(MultiLabelInstances mlData, String currentLabel, boolean keepSubTree) throws InvalidDataFormatException {
        LabelNodeImpl rootNode;
        Set<String> labelsToKeep;
        LabelsMetaData currentMetaData = mlData.getLabelsMetaData();
        LabelNodeImpl currentLabelNode = (LabelNodeImpl)currentMetaData.getLabelNode(currentLabel);
        Set<String> allLabels = mlData.getLabelsMetaData().getLabelNames();
        LabelsMetaDataImpl labelsMetaData = new LabelsMetaDataImpl();
        if (keepSubTree) {
            labelsToKeep = currentLabelNode.getDescendantLabels();
            for (String rootLabel : currentLabelNode.getChildrenLabels()) {
                rootNode = new LabelNodeImpl(rootLabel);
                if (mlData.getLabelsMetaData().getLabelNode(rootLabel).hasChildren()) {
                    this.append(rootNode, mlData.getLabelsMetaData());
                }
                labelsMetaData.addRootNode(rootNode);
            }
        } else {
            labelsToKeep = currentLabelNode.getChildrenLabels();
            for (String rootLabel : labelsToKeep) {
                rootNode = new LabelNodeImpl(rootLabel);
                labelsMetaData.addRootNode(rootNode);
            }
        }
        for (String label : allLabels) {
            if (labelsToKeep.contains(label)) continue;
            int idx = mlData.getDataSet().attribute(label).index();
            mlData.getDataSet().deleteAttributeAt(idx);
        }
        return new MultiLabelInstances(mlData.getDataSet(), labelsMetaData);
    }

    private void append(LabelNodeImpl labelNode, LabelsMetaData labelsMetaData) {
        LabelNode father = labelsMetaData.getLabelNode(labelNode.getName());
        for (LabelNode child : father.getChildren()) {
            LabelNodeImpl newLabelNode = new LabelNodeImpl(child.getName());
            if (child.hasChildren()) {
                this.append(newLabelNode, labelsMetaData);
            }
            labelNode.addChildNode(newLabelNode);
        }
    }

    protected void deleteInstances(Instances trainSet, int attrIndex) {
        for (int i = 0; i < trainSet.numInstances(); ++i) {
            if (!trainSet.instance(i).stringValue(attrIndex).equals("0")) continue;
            trainSet.delete(i);
            --i;
        }
    }

    public long getNoNodes() {
        return this.NoNodes;
    }

    public long getNoClassifierEvals() {
        return this.NoClassifierEvals;
    }

    public long getTotalUsedTrainInsts() {
        return this.TotalUsedTrainInsts;
    }

    @Override
    public String globalInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("Class that implements a Hierarchical Multilabel classifier");
        sb.append(" (HMC). HMC classifier takes as parameter any kind of ");
        sb.append("multilabel classifier and builds a hierarchy. Any node of ");
        sb.append("hierarchy is a classifier and is trained separately. The ");
        sb.append("root classifier is trained on all data and as getting down");
        sb.append(" the hierarchy tree the data is adjusted properly to each ");
        sb.append("node. Firstly, instances that do not belong to the node ");
        sb.append("are removed and then attributes that are unnecessary are ");
        sb.append("removed also. For more information, see\n\n");
        sb.append(this.getTechnicalInformation());
        return sb.toString();
    }
}

