/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import mulan.classifier.meta.ConstrainedKMeans;
import mulan.data.DataUtils;
import mulan.data.InvalidDataFormatException;
import mulan.data.LabelNode;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsMetaData;
import mulan.data.LabelsMetaDataImpl;
import mulan.data.MultiLabelInstances;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weka.clusterers.EM;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffSaver;

public class HierarchyBuilder
implements Serializable {
    private int numPartitions;
    private Document labelsXMLDoc;
    private Method method;

    public HierarchyBuilder(int partitions, Method method) {
        this.numPartitions = partitions;
        this.method = method;
    }

    public MultiLabelInstances buildHierarchy(MultiLabelInstances mlData) throws Exception {
        LabelsMetaData labelsMetaData = this.buildLabelHierarchy(mlData);
        return HierarchyBuilder.createHierarchicalDataset(mlData, labelsMetaData);
    }

    public LabelsMetaData buildLabelHierarchy(MultiLabelInstances mlData) throws Exception {
        if (this.numPartitions > mlData.getNumLabels()) {
            throw new IllegalArgumentException("Number of labels is smaller than the number of partitions");
        }
        Set<String> setOfLabels = mlData.getLabelsMetaData().getLabelNames();
        ArrayList<String> listOfLabels = new ArrayList<String>();
        for (String label : setOfLabels) {
            listOfLabels.add(label);
        }
        ArrayList<String>[] childrenLabels = null;
        switch (this.method) {
            case Random: {
                childrenLabels = this.randomPartitioning(this.numPartitions, listOfLabels);
                break;
            }
            case Clustering: {
                childrenLabels = this.clustering(this.numPartitions, listOfLabels, mlData, false);
                break;
            }
            case BalancedClustering: {
                childrenLabels = this.clustering(this.numPartitions, listOfLabels, mlData, true);
            }
        }
        for (int i = 0; i < this.numPartitions; ++i) {
            if (childrenLabels[i].size() != listOfLabels.size()) continue;
            childrenLabels = this.randomPartitioning(this.numPartitions, listOfLabels);
            break;
        }
        LabelsMetaDataImpl metaData = new LabelsMetaDataImpl();
        for (int i = 0; i < this.numPartitions; ++i) {
            if (childrenLabels[i].isEmpty()) continue;
            if (childrenLabels[i].size() == 1) {
                metaData.addRootNode(new LabelNodeImpl(childrenLabels[i].get(0)));
                continue;
            }
            if (childrenLabels[i].size() <= 1) continue;
            LabelNodeImpl metaLabel = new LabelNodeImpl("MetaLabel " + (i + 1));
            this.createLabelsMetaDataRecursive(metaLabel, childrenLabels[i], mlData);
            metaData.addRootNode(metaLabel);
        }
        return metaData;
    }

    public MultiLabelInstances buildHierarchyAndSaveFiles(MultiLabelInstances mlData, String arffName, String xmlName) throws Exception {
        MultiLabelInstances newData = this.buildHierarchy(mlData);
        this.saveToArffFile(newData.getDataSet(), new File(arffName));
        this.createXMLFile(mlData.getLabelsMetaData());
        this.saveToXMLFile(xmlName);
        return newData;
    }

    private void createLabelsMetaDataRecursive(LabelNodeImpl node, List<String> labels, MultiLabelInstances mlData) {
        int i;
        if (labels.size() <= this.numPartitions) {
            for (int i2 = 0; i2 < labels.size(); ++i2) {
                LabelNodeImpl child = new LabelNodeImpl(labels.get(i2));
                node.addChildNode(child);
            }
            return;
        }
        ArrayList<String>[] childrenLabels = null;
        switch (this.method) {
            case Random: {
                childrenLabels = this.randomPartitioning(this.numPartitions, labels);
                break;
            }
            case Clustering: {
                childrenLabels = this.clustering(this.numPartitions, labels, mlData, false);
                break;
            }
            case BalancedClustering: {
                childrenLabels = this.clustering(this.numPartitions, labels, mlData, true);
            }
        }
        for (i = 0; i < this.numPartitions; ++i) {
            if (childrenLabels[i].size() != labels.size()) continue;
            childrenLabels = this.randomPartitioning(this.numPartitions, labels);
            break;
        }
        for (i = 0; i < this.numPartitions; ++i) {
            LabelNodeImpl child;
            if (childrenLabels[i].isEmpty()) continue;
            if (childrenLabels[i].size() == 1) {
                child = new LabelNodeImpl(childrenLabels[i].get(0));
                node.addChildNode(child);
                continue;
            }
            if (childrenLabels[i].size() <= 1) continue;
            child = new LabelNodeImpl(node.getName() + "." + (i + 1));
            node.addChildNode(child);
            this.createLabelsMetaDataRecursive(child, childrenLabels[i], mlData);
        }
    }

    private ArrayList<String>[] clustering(int clusters, List<String> labels, MultiLabelInstances mlData, boolean balanced) {
        int i;
        ArrayList[] childrenLabels = new ArrayList[clusters];
        for (int i2 = 0; i2 < clusters; ++i2) {
            childrenLabels[i2] = new ArrayList();
        }
        int numInstances = mlData.getDataSet().numInstances();
        ArrayList<Attribute> attInfo = new ArrayList<Attribute>(numInstances);
        for (int i3 = 0; i3 < numInstances; ++i3) {
            Attribute att = new Attribute("instance" + (i3 + 1));
            attInfo.add(att);
        }
        System.out.println(new Date() + " constructing instances");
        Instances transposed = new Instances("transposed", attInfo, 0);
        int[] labelIndices = mlData.getLabelIndices();
        for (int i4 = 0; i4 < labels.size(); ++i4) {
            int index = -1;
            for (int k = 0; k < labelIndices.length; ++k) {
                if (!mlData.getDataSet().attribute(labelIndices[k]).name().equals(labels.get(i4))) continue;
                index = labelIndices[k];
            }
            double[] values = new double[numInstances];
            for (int j = 0; j < numInstances; ++j) {
                values[j] = mlData.getDataSet().instance(j).value(index);
            }
            Instance newInstance = DataUtils.createInstance(mlData.getDataSet().instance(0), 1.0, values);
            transposed.add(newInstance);
        }
        if (!balanced) {
            EM clusterer = new EM();
            try {
                clusterer.setNumClusters(clusters);
                System.out.println("clustering");
                clusterer.buildClusterer(transposed);
                for (i = 0; i < labels.size(); ++i) {
                    childrenLabels[clusterer.clusterInstance(transposed.instance(i))].add(labels.get(i));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(HierarchyBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            ConstrainedKMeans clusterer = new ConstrainedKMeans();
            try {
                clusterer.setMaxIterations(20);
                clusterer.setNumClusters(clusters);
                System.out.println("balanced clustering");
                clusterer.buildClusterer(transposed);
                for (i = 0; i < labels.size(); ++i) {
                    childrenLabels[clusterer.clusterInstance(transposed.instance(i))].add(labels.get(i));
                }
            }
            catch (Exception ex) {
                Logger.getLogger(HierarchyBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return childrenLabels;
    }

    private ArrayList<String>[] randomPartitioning(int partitions, List<String> labels) {
        ArrayList[] childrenLabels = new ArrayList[partitions];
        for (int i = 0; i < partitions; ++i) {
            childrenLabels[i] = new ArrayList();
        }
        Random rnd = new Random();
        while (!labels.isEmpty()) {
            for (int i = 0; i < partitions && !labels.isEmpty(); ++i) {
                String rndLabel = labels.remove(rnd.nextInt(labels.size()));
                childrenLabels[i].add(rndLabel);
            }
        }
        return childrenLabels;
    }

    public static MultiLabelInstances createHierarchicalDataset(MultiLabelInstances mlData, LabelsMetaData metaData) throws InvalidDataFormatException {
        Set<String> leafLabels = mlData.getLabelsMetaData().getLabelNames();
        Set<String> metaLabels = metaData.getLabelNames();
        for (String string : leafLabels) {
            metaLabels.remove(string);
        }
        Instances dataSet = mlData.getDataSet();
        int numMetaLabels = metaLabels.size();
        ArrayList<Attribute> atts = new ArrayList<Attribute>(dataSet.numAttributes() + numMetaLabels);
        for (int i = 0; i < dataSet.numAttributes(); ++i) {
            atts.add(dataSet.attribute(i));
        }
        ArrayList<String> labelValues = new ArrayList<String>();
        labelValues.add("0");
        labelValues.add("1");
        for (String metaLabel : metaLabels) {
            atts.add(new Attribute(metaLabel, labelValues));
        }
        Instances newDataSet = new Instances("hierarchical", atts, dataSet.numInstances());
        for (int i = 0; i < dataSet.numInstances(); ++i) {
            double[] newValues = new double[newDataSet.numAttributes()];
            Arrays.fill(newValues, 0.0);
            double[] values = dataSet.instance(i).toDoubleArray();
            System.arraycopy(values, 0, newValues, 0, values.length);
            for (String label : leafLabels) {
                Attribute currentAtt;
                Attribute att = dataSet.attribute(label);
                if (!att.value((int)dataSet.instance(i).value(att)).equals("1")) continue;
                LabelNode currentNode = metaData.getLabelNode(label);
                while (currentNode.hasParent() && newValues[atts.indexOf(currentAtt = newDataSet.attribute((currentNode = currentNode.getParent()).getName()))] != 1.0) {
                    newValues[atts.indexOf((Object)currentAtt)] = 1.0;
                }
            }
            Instance instance = dataSet.instance(i);
            newDataSet.add(DataUtils.createInstance(instance, instance.weight(), newValues));
        }
        return new MultiLabelInstances(newDataSet, metaData);
    }

    private void saveToArffFile(Instances dataSet, File file) throws IOException {
        ArffSaver saver = new ArffSaver();
        saver.setInstances(dataSet);
        saver.setFile(file);
        saver.writeBatch();
    }

    private void createXMLFile(LabelsMetaData metaData) throws Exception {
        DocumentBuilderFactory docBF = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBF.newDocumentBuilder();
        this.labelsXMLDoc = docBuilder.newDocument();
        Element rootElement = this.labelsXMLDoc.createElement("labels");
        rootElement.setAttribute("xmlns", "http://mulan.sourceforge.net/labels");
        this.labelsXMLDoc.appendChild(rootElement);
        for (LabelNode rootLabel : metaData.getRootLabels()) {
            Element newLabelElem = this.labelsXMLDoc.createElement("label");
            newLabelElem.setAttribute("name", rootLabel.getName());
            this.appendElement(newLabelElem, rootLabel);
            rootElement.appendChild(newLabelElem);
        }
    }

    private void saveToXMLFile(String fileName) {
        DOMSource source = new DOMSource(this.labelsXMLDoc);
        File xmlFile = new File(fileName);
        StreamResult result = new StreamResult(xmlFile);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setOutputProperty("method", "xml");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void appendElement(Element labelElem, LabelNode labelNode) {
        for (LabelNode childNode : labelNode.getChildren()) {
            Element newLabelElem = this.labelsXMLDoc.createElement("label");
            newLabelElem.setAttribute("name", childNode.getName());
            this.appendElement(newLabelElem, childNode);
            labelElem.appendChild(newLabelElem);
        }
    }

    public static enum Method {
        Random,
        Clustering,
        BalancedClustering;

    }
}

