/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta.thresholding;

import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.thresholding.Meta;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class MetaLabeler
extends Meta {
    private String classChoice;

    public MetaLabeler() {
        this(new BinaryRelevance((Classifier)new J48()), (Classifier)new J48(), "Content-based", "Nominal-Class");
    }

    public MetaLabeler(MultiLabelLearner baseLearner, Classifier classifier, String metaDataChoice, String aClassChoice) {
        super(baseLearner, classifier, metaDataChoice);
        if (!metaDataChoice.equals("Content-Based")) {
            try {
                this.foldLearner = baseLearner.makeCopy();
            }
            catch (Exception ex) {
                Logger.getLogger(MetaLabeler.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.kFoldsCV = 3;
        }
        this.classChoice = aClassChoice;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Lei Tang and Sugu Rajan and Yijay K. Narayanan");
        result.setValue(TechnicalInformation.Field.TITLE, "Large scale multi-label classification via metalabeler");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 18th international conference on World wide web ");
        result.setValue(TechnicalInformation.Field.PAGES, "211-220");
        result.setValue(TechnicalInformation.Field.LOCATION, "Madrid, Spain");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        return result;
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        int bipartition_key;
        double classify_key;
        MultiLabelOutput mlo = this.baseLearner.makePrediction(instance);
        boolean[] predictedLabels = new boolean[this.numLabels];
        Instance modifiedIns = this.modifiedInstanceX(instance, this.metaDatasetChoice);
        modifiedIns.insertAttributeAt(modifiedIns.numAttributes());
        modifiedIns.setDataset(this.classifierInstances);
        if (this.classChoice.compareTo("Nominal-Class") == 0) {
            classify_key = this.classifier.classifyInstance(modifiedIns);
            String s = this.classifierInstances.attribute(this.classifierInstances.numAttributes() - 1).value((int)classify_key);
            bipartition_key = Integer.valueOf(s);
        } else {
            classify_key = this.classifier.classifyInstance(modifiedIns);
            bipartition_key = (int)Math.round(classify_key);
        }
        if (mlo.hasRanking()) {
            int[] arrayOfRankink = mlo.getRanking();
            for (int i = 0; i < this.numLabels; ++i) {
                predictedLabels[i] = arrayOfRankink[i] <= bipartition_key;
            }
        }
        MultiLabelOutput final_mlo = new MultiLabelOutput(predictedLabels, mlo.getConfidences());
        return final_mlo;
    }

    private int countTrueLabels(Instance instance) {
        int numTrueLabels = 0;
        for (int i = 0; i < this.numLabels; ++i) {
            int labelIndice = this.labelIndices[i];
            if (!instance.dataset().attribute(labelIndice).value((int)instance.value(labelIndice)).equals("1")) continue;
            ++numTrueLabels;
        }
        return numTrueLabels;
    }

    @Override
    protected Instances transformData(MultiLabelInstances trainingData) throws Exception {
        this.classifierInstances = RemoveAllLabels.transformInstances(trainingData);
        this.classifierInstances = new Instances(this.classifierInstances, 0);
        Attribute target = null;
        if (this.classChoice.equals("Nominal-Class")) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int instanceIndex = 0; instanceIndex < trainingData.getDataSet().numInstances(); ++instanceIndex) {
                int countTrueLabels = 0;
                for (int i = 0; i < this.numLabels; ++i) {
                    int labelIndice = this.labelIndices[i];
                    if (!trainingData.getDataSet().attribute(labelIndice).value((int)trainingData.getDataSet().instance(instanceIndex).value(labelIndice)).equals("1")) continue;
                    ++countTrueLabels;
                }
                treeSet.add(countTrueLabels);
            }
            ArrayList<String> classlabel = new ArrayList<String>();
            for (Integer x : treeSet) {
                classlabel.add(x.toString());
            }
            target = new Attribute("Class", classlabel);
        } else if (this.classChoice.equals("Numeric-Class")) {
            target = new Attribute("Class");
        }
        this.classifierInstances.insertAttributeAt(target, this.classifierInstances.numAttributes());
        this.classifierInstances.setClassIndex(this.classifierInstances.numAttributes() - 1);
        if (this.metaDatasetChoice.equals("Content-Based")) {
            for (int instanceIndex = 0; instanceIndex < trainingData.getNumInstances(); ++instanceIndex) {
                Instance instance = trainingData.getDataSet().instance(instanceIndex);
                double[] values = instance.toDoubleArray();
                double[] newValues = new double[this.classifierInstances.numAttributes()];
                for (int i = 0; i < this.featureIndices.length; ++i) {
                    newValues[i] = values[this.featureIndices[i]];
                }
                int numTrueLabels = this.countTrueLabels(instance);
                if (this.classChoice.compareTo("Nominal-Class") == 0) {
                    newValues[newValues.length - 1] = this.classifierInstances.attribute(this.classifierInstances.numAttributes() - 1).indexOfValue("" + numTrueLabels);
                } else if (this.classChoice.compareTo("Numeric-Class") == 0) {
                    newValues[newValues.length - 1] = numTrueLabels;
                }
                Instance newInstance = DataUtils.createInstance(instance, instance.weight(), newValues);
                this.classifierInstances.add(newInstance);
            }
        } else {
            for (int k = 0; k < this.kFoldsCV; ++k) {
                MultiLabelInstances mlTest;
                MultiLabelLearner tempLearner;
                if (this.kFoldsCV == 1) {
                    tempLearner = this.baseLearner;
                    mlTest = trainingData;
                } else {
                    Instances train = trainingData.getDataSet().trainCV(this.kFoldsCV, k);
                    Instances test = trainingData.getDataSet().testCV(this.kFoldsCV, k);
                    MultiLabelInstances mlTrain = new MultiLabelInstances(train, trainingData.getLabelsMetaData());
                    mlTest = new MultiLabelInstances(test, trainingData.getLabelsMetaData());
                    tempLearner = this.foldLearner.makeCopy();
                    tempLearner.build(mlTrain);
                }
                for (int instanceIndex = 0; instanceIndex < mlTest.getDataSet().numInstances(); ++instanceIndex) {
                    Instance instance = mlTest.getDataSet().instance(instanceIndex);
                    double[] newValues = new double[this.classifierInstances.numAttributes()];
                    this.valuesX(tempLearner, instance, newValues, this.metaDatasetChoice);
                    int numTrueLabels = this.countTrueLabels(instance);
                    if (this.classChoice.compareTo("Nominal-Class") == 0) {
                        newValues[newValues.length - 1] = this.classifierInstances.attribute(this.classifierInstances.numAttributes() - 1).indexOfValue("" + numTrueLabels);
                    } else if (this.classChoice.compareTo("Numeric-Class") == 0) {
                        newValues[newValues.length - 1] = numTrueLabels;
                    }
                    Instance newInstance = DataUtils.createInstance(mlTest.getDataSet().instance(instanceIndex), mlTest.getDataSet().instance(instanceIndex).weight(), newValues);
                    this.classifierInstances.add(newInstance);
                }
            }
        }
        return this.classifierInstances;
    }

    public void setFolds(int f) {
        this.kFoldsCV = f;
    }

    @Override
    public String globalInfo() {
        return "Class implementing the MetaLabeler algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

