/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.Arrays;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Reorder;

public class CalibratedLabelRanking
extends TransformationBasedMultiLabelLearner {
    protected Classifier[] oneVsOneModels;
    protected int numModels;
    protected Instances trainingdata;
    protected Instances[] metaDataTest;
    protected BinaryRelevance virtualLabelModels;
    private boolean useStandardVoting = true;
    protected boolean[] nodata;

    public CalibratedLabelRanking() {
        super((Classifier)new J48());
    }

    public CalibratedLabelRanking(Classifier classifier) {
        super(classifier);
    }

    public void setStandardVoting(boolean standardVoting) {
        this.useStandardVoting = standardVoting;
    }

    public boolean getStandardVoting() {
        return this.useStandardVoting;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        this.debug("Building calibration label models");
        this.virtualLabelModels = new BinaryRelevance(this.getBaseClassifier());
        this.virtualLabelModels.setDebug(this.getDebug());
        this.virtualLabelModels.build(trainingSet);
        this.numModels = this.numLabels * (this.numLabels - 1) / 2;
        this.oneVsOneModels = AbstractClassifier.makeCopies((Classifier)this.getBaseClassifier(), (int)this.numModels);
        this.nodata = new boolean[this.numModels];
        this.metaDataTest = new Instances[this.numModels];
        Instances trainingData = trainingSet.getDataSet();
        int counter = 0;
        for (int label1 = 0; label1 < this.numLabels - 1; ++label1) {
            Attribute attrLabel1 = trainingData.attribute(this.labelIndices[label1]);
            for (int label2 = label1 + 1; label2 < this.numLabels; ++label2) {
                this.debug("Building one-vs-one model " + (counter + 1) + "/" + this.numModels);
                Attribute attrLabel2 = trainingData.attribute(this.labelIndices[label2]);
                Instances dataOneVsOne = new Instances(trainingData, 0);
                for (int i = 0; i < trainingData.numInstances(); ++i) {
                    String value2;
                    Object tempInstance = trainingData.instance(i) instanceof SparseInstance ? new SparseInstance(trainingData.instance(i)) : new DenseInstance(trainingData.instance(i));
                    int nominalValueIndex = (int)tempInstance.value(this.labelIndices[label1]);
                    String value1 = attrLabel1.value(nominalValueIndex);
                    if (value1.equals(value2 = attrLabel2.value(nominalValueIndex = (int)tempInstance.value(this.labelIndices[label2])))) continue;
                    tempInstance.setValue(attrLabel1, value1);
                    dataOneVsOne.add((Instance)tempInstance);
                }
                Reorder filter = new Reorder();
                int numPredictors = trainingData.numAttributes() - this.numLabels;
                int[] reorderedIndices = new int[numPredictors + 1];
                System.arraycopy(this.featureIndices, 0, reorderedIndices, 0, numPredictors);
                reorderedIndices[numPredictors] = this.labelIndices[label1];
                filter.setAttributeIndicesArray(reorderedIndices);
                filter.setInputFormat(dataOneVsOne);
                dataOneVsOne = Filter.useFilter((Instances)dataOneVsOne, (Filter)filter);
                dataOneVsOne.setClassIndex(numPredictors);
                if (dataOneVsOne.size() > 0) {
                    this.oneVsOneModels[counter].buildClassifier(dataOneVsOne);
                } else {
                    this.nodata[counter] = true;
                }
                dataOneVsOne.delete();
                this.metaDataTest[counter] = dataOneVsOne;
                ++counter;
            }
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        if (this.useStandardVoting) {
            return this.makePredictionStandard(instance);
        }
        return this.makePredictionQW(instance);
    }

    public MultiLabelOutput makePredictionStandard(Instance instance) throws Exception {
        int i;
        boolean[] bipartition = new boolean[this.numLabels];
        double[] confidences = new double[this.numLabels];
        int[] voteLabel = new int[this.numLabels + 1];
        Instance newInstance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
        newInstance.insertAttributeAt(newInstance.numAttributes());
        Arrays.fill(voteLabel, 0);
        int counter = 0;
        for (int label1 = 0; label1 < this.numLabels - 1; ++label1) {
            for (int label2 = label1 + 1; label2 < this.numLabels; ++label2) {
                if (!this.nodata[counter]) {
                    double[] distribution;
                    try {
                        newInstance.setDataset(this.metaDataTest[counter]);
                        distribution = this.oneVsOneModels[counter].distributionForInstance(newInstance);
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        return null;
                    }
                    int maxIndex = distribution[0] > distribution[1] ? 0 : 1;
                    Attribute classAttribute = this.metaDataTest[counter].classAttribute();
                    if (classAttribute.value(maxIndex).equals("1")) {
                        int n = label1;
                        voteLabel[n] = voteLabel[n] + 1;
                    } else {
                        int n = label2;
                        voteLabel[n] = voteLabel[n] + 1;
                    }
                }
                ++counter;
            }
        }
        int voteVirtual = 0;
        MultiLabelOutput virtualMLO = this.virtualLabelModels.makePrediction(instance);
        boolean[] virtualBipartition = virtualMLO.getBipartition();
        for (i = 0; i < this.numLabels; ++i) {
            if (virtualBipartition[i]) {
                int n = i;
                voteLabel[n] = voteLabel[n] + 1;
                continue;
            }
            ++voteVirtual;
        }
        for (i = 0; i < this.numLabels; ++i) {
            bipartition[i] = voteLabel[i] >= voteVirtual;
            confidences[i] = 1.0 * (double)voteLabel[i] / (double)this.numLabels;
        }
        MultiLabelOutput mlo = new MultiLabelOutput(bipartition, confidences);
        return mlo;
    }

    public MultiLabelOutput makePredictionQW(Instance instance) throws Exception {
        int i;
        int[] voteLabel = new int[this.numLabels];
        int[] played = new int[this.numLabels + 1];
        int[][] playedMatrix = new int[this.numLabels + 1][this.numLabels + 1];
        double[] limits = new double[this.numLabels];
        boolean[] bipartition = new boolean[this.numLabels];
        double[] confidences = new double[this.numLabels];
        int voteVirtual = 0;
        boolean allEqualClassesFound = false;
        Instance newInstance = RemoveAllLabels.transformInstance(instance, this.labelIndices);
        newInstance.insertAttributeAt(newInstance.numAttributes());
        Arrays.fill(voteLabel, 0);
        MultiLabelOutput virtualMLO = this.virtualLabelModels.makePrediction(instance);
        boolean[] virtualBipartition = virtualMLO.getBipartition();
        for (int i2 = 0; i2 < this.numLabels; ++i2) {
            if (virtualBipartition[i2]) {
                int n = i2;
                voteLabel[n] = voteLabel[n] + 1;
            } else {
                ++voteVirtual;
            }
            int n = i2;
            played[n] = played[n] + 1;
            playedMatrix[i2][this.numLabels] = 1;
            playedMatrix[this.numLabels][i2] = 1;
            limits[i2] = played[i2] - voteLabel[i2];
        }
        double limitVirtual = this.numLabels - voteVirtual;
        played[this.numLabels] = this.numLabels;
        boolean found = false;
        int player1 = -1;
        for (int pos = 0; !allEqualClassesFound && pos < this.numLabels; ++pos) {
            while (!found) {
                int[] sortarr = Utils.sort((double[])limits);
                player1 = sortarr[0];
                int player2 = -1;
                if (played[player1] < this.numLabels) {
                    for (i = 1; player2 == -1 && i < sortarr.length; ++i) {
                        if (playedMatrix[player1][sortarr[i]] != 0) continue;
                        player2 = sortarr[i];
                    }
                    int modelIndex = this.getRRClassifierIndex(player1, player2);
                    newInstance.setDataset(this.metaDataTest[modelIndex]);
                    double[] distribution = this.oneVsOneModels[modelIndex].distributionForInstance(newInstance);
                    int maxIndex = distribution[0] > distribution[1] ? 0 : 1;
                    Attribute classAttribute = this.metaDataTest[modelIndex].classAttribute();
                    if (classAttribute.value(maxIndex).equals("1")) {
                        int n = player1 > player2 ? player2 : player1;
                        voteLabel[n] = voteLabel[n] + 1;
                    } else {
                        int n = player1 > player2 ? player1 : player2;
                        voteLabel[n] = voteLabel[n] + 1;
                    }
                    int n = player1;
                    played[n] = played[n] + 1;
                    int n2 = player2;
                    played[n2] = played[n2] + 1;
                    playedMatrix[player1][player2] = 1;
                    playedMatrix[player2][player1] = 1;
                    limits[player1] = played[player1] - voteLabel[player1];
                    limits[player2] = played[player2] - voteLabel[player2];
                    continue;
                }
                found = true;
            }
            limits[player1] = Double.MAX_VALUE;
            allEqualClassesFound = true;
            for (i = 0; i < this.numLabels; ++i) {
                if (!(limits[i] <= limitVirtual)) continue;
                allEqualClassesFound = false;
            }
            found = false;
        }
        for (i = 0; i < this.numLabels; ++i) {
            bipartition[i] = voteLabel[i] >= voteVirtual;
            confidences[i] = 1.0 * (double)voteLabel[i] / (double)this.numLabels;
        }
        MultiLabelOutput mlo = new MultiLabelOutput(bipartition, confidences);
        return mlo;
    }

    private int getRRClassifierIndex(int label1, int label2) {
        int l2;
        int l1 = label1 > label2 ? label2 : label1;
        int n = l2 = label1 > label2 ? label1 : label2;
        if (l1 == 0) {
            return l2 - 1;
        }
        int temp = 0;
        for (int i = l1; i > 0; --i) {
            temp += this.numLabels - i;
        }
        return temp += l2 - (l1 + 1);
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Calibrated Label Ranking (CLR) algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Fuernkranz, Johannes and Huellermeier, Eyke and Loza Mencia, Eneldo and Brinker, Klaus");
        result.setValue(TechnicalInformation.Field.TITLE, "Multilabel classification via calibrated label ranking");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        result.setValue(TechnicalInformation.Field.VOLUME, "73");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "133--153");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        return result;
    }
}

