/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.DataUtils;
import mulan.data.MultiLabelInstances;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.trees.J48;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClassifierChain
extends TransformationBasedMultiLabelLearner {
    private int[] chain;
    protected FilteredClassifier[] ensemble;

    @Override
    public String globalInfo() {
        return "Class implementing the Classifier Chain (CC) algorithm.\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Read, Jesse and Pfahringer, Bernhard and Holmes, Geoff and Frank, Eibe");
        result.setValue(TechnicalInformation.Field.TITLE, "Classifier Chains for Multi-label Classification");
        result.setValue(TechnicalInformation.Field.VOLUME, "85");
        result.setValue(TechnicalInformation.Field.NUMBER, "3");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.PAGES, "335--359");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Machine Learning");
        return result;
    }

    public ClassifierChain() {
        super((Classifier)new J48());
    }

    public ClassifierChain(Classifier classifier, int[] aChain) {
        super(classifier);
        this.chain = aChain;
    }

    public ClassifierChain(Classifier classifier) {
        super(classifier);
    }

    @Override
    protected void buildInternal(MultiLabelInstances train) throws Exception {
        if (this.chain == null) {
            this.chain = new int[this.numLabels];
            for (int i = 0; i < this.numLabels; ++i) {
                this.chain[i] = i;
            }
        }
        this.numLabels = train.getNumLabels();
        this.ensemble = new FilteredClassifier[this.numLabels];
        Instances trainDataset = train.getDataSet();
        for (int i = 0; i < this.numLabels; ++i) {
            this.ensemble[i] = new FilteredClassifier();
            this.ensemble[i].setClassifier(AbstractClassifier.makeCopy((Classifier)this.baseClassifier));
            int[] indicesToRemove = new int[this.numLabels - 1 - i];
            int counter2 = 0;
            for (int counter1 = 0; counter1 < this.numLabels - i - 1; ++counter1) {
                indicesToRemove[counter1] = this.labelIndices[this.chain[this.numLabels - 1 - counter2]];
                ++counter2;
            }
            Remove remove = new Remove();
            remove.setAttributeIndicesArray(indicesToRemove);
            remove.setInputFormat(trainDataset);
            remove.setInvertSelection(false);
            this.ensemble[i].setFilter((Filter)remove);
            trainDataset.setClassIndex(this.labelIndices[this.chain[i]]);
            this.debug("Bulding model " + (i + 1) + "/" + this.numLabels);
            this.ensemble[i].buildClassifier(trainDataset);
        }
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        boolean[] bipartition = new boolean[this.numLabels];
        double[] confidences = new double[this.numLabels];
        Instance tempInstance = DataUtils.createInstance(instance, instance.weight(), instance.toDoubleArray());
        for (int counter = 0; counter < this.numLabels; ++counter) {
            double[] distribution;
            try {
                distribution = this.ensemble[counter].distributionForInstance(tempInstance);
            }
            catch (Exception e) {
                System.out.println(e);
                return null;
            }
            int maxIndex = distribution[0] > distribution[1] ? 0 : 1;
            Attribute classAttribute = this.ensemble[counter].getFilter().getOutputFormat().classAttribute();
            bipartition[this.chain[counter]] = classAttribute.value(maxIndex).equals("1");
            confidences[this.chain[counter]] = distribution[classAttribute.indexOfValue("1")];
            tempInstance.setValue(this.labelIndices[this.chain[counter]], (double)maxIndex);
        }
        MultiLabelOutput mlo = new MultiLabelOutput(bipartition, confidences);
        return mlo;
    }
}

