/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import mulan.transformations.IncludeLabelsTransformation;
import weka.classifiers.Classifier;
import weka.core.Instance;
import weka.core.Instances;

public class IncludeLabelsClassifier
extends TransformationBasedMultiLabelLearner {
    private IncludeLabelsTransformation pt6Trans;
    protected Instances transformed;

    public IncludeLabelsClassifier(Classifier classifier) {
        super(classifier);
    }

    @Override
    public void buildInternal(MultiLabelInstances mlData) throws Exception {
        this.pt6Trans = new IncludeLabelsTransformation();
        this.debug("Transforming the dataset");
        this.transformed = this.pt6Trans.transformInstances(mlData);
        this.debug("Building the base-level classifier");
        this.baseClassifier.buildClassifier(this.transformed);
        this.transformed.delete();
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        double[] confidences = new double[this.numLabels];
        boolean[] bipartition = new boolean[this.numLabels];
        Instance newInstance = this.pt6Trans.transformInstance(instance);
        for (int i = 0; i < this.numLabels; ++i) {
            newInstance.setDataset(this.transformed);
            newInstance.setValue(newInstance.numAttributes() - 2, instance.dataset().attribute(this.labelIndices[i]).name());
            double[] temp = this.baseClassifier.distributionForInstance(newInstance);
            confidences[i] = temp[this.transformed.classAttribute().indexOfValue("1")];
            bipartition[i] = temp[this.transformed.classAttribute().indexOfValue("1")] >= temp[this.transformed.classAttribute().indexOfValue("0")];
        }
        MultiLabelOutput mlo = new MultiLabelOutput(bipartition, confidences);
        return mlo;
    }
}

