/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.transformation.LabelsetPruning;
import mulan.data.DataUtils;
import mulan.data.LabelSet;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.TechnicalInformation;

public class PrunedSets
extends LabelsetPruning {
    private Strategy strategy;
    private int b;

    public PrunedSets() {
        this((Classifier)new J48(), 3, Strategy.A, 2);
    }

    public PrunedSets(Classifier classifier, int aP, Strategy aStrategy, int aB) {
        super(classifier, aP);
        this.b = aB;
        this.strategy = aStrategy;
        this.setConfidenceCalculationMethod(2);
        this.setMakePredictionsBasedOnConfidences(false);
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Read, Jesse and Pfahringer, Bernhard and Holmes, Geoff");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-Label Classification using Ensembles of Pruned Sets");
        result.setValue(TechnicalInformation.Field.PAGES, "995-1000");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. 8th IEEE International Conference on Data Mining (ICDM 2008)");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Pruned Sets algorithm (PS). For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    ArrayList<Instance> processRejected(LabelSet ls) {
        ArrayList<LabelSet> subsets = null;
        ArrayList instances = null;
        ArrayList<Instance> newInstances = null;
        switch (this.strategy) {
            case A: {
                subsets = null;
                try {
                    subsets = ls.getSubsets();
                }
                catch (Exception ex) {
                    Logger.getLogger(PrunedSets.class.getName()).log(Level.SEVERE, null, ex);
                }
                ArrayList<LabelSet> sortedSubsets = new ArrayList<LabelSet>();
                for (LabelSet l : subsets) {
                    if (!this.ListInstancePerLabel.containsKey(l) || ((ArrayList)this.ListInstancePerLabel.get(l)).size() <= this.p) continue;
                    boolean added = false;
                    for (int i = 0; i < sortedSubsets.size(); ++i) {
                        LabelSet l2 = (LabelSet)sortedSubsets.get(i);
                        if (l.size() > l2.size()) {
                            sortedSubsets.add(i, l);
                            added = true;
                            break;
                        }
                        if (l.size() != l2.size() || ((ArrayList)this.ListInstancePerLabel.get(l)).size() <= ((ArrayList)this.ListInstancePerLabel.get(l2)).size()) continue;
                        sortedSubsets.add(i, l);
                        added = true;
                        break;
                    }
                    if (added) continue;
                    sortedSubsets.add(l);
                }
                newInstances = new ArrayList<Instance>();
                instances = (ArrayList)this.ListInstancePerLabel.get(ls);
                block10: for (Instance tempInstance : instances) {
                    int counter = 0;
                    for (LabelSet l : sortedSubsets) {
                        double[] temp = tempInstance.toDoubleArray();
                        double[] tempLabels = l.toDoubleArray();
                        for (int i = 0; i < this.numLabels; ++i) {
                            temp[this.labelIndices[i]] = this.format.attribute(this.labelIndices[i]).value(0).equals("0") ? tempLabels[i] : 1.0 - tempLabels[i];
                        }
                        Instance newInstance = DataUtils.createInstance(tempInstance, 1.0, temp);
                        newInstances.add(newInstance);
                        if (++counter != this.b) continue;
                        continue block10;
                    }
                }
                return newInstances;
            }
            case B: {
                subsets = null;
                try {
                    subsets = ls.getSubsets();
                }
                catch (Exception ex) {
                    Logger.getLogger(PrunedSets.class.getName()).log(Level.SEVERE, null, ex);
                }
                ArrayList<LabelSet> subsetsForInsertion = new ArrayList<LabelSet>();
                for (LabelSet l : subsets) {
                    if (!this.ListInstancePerLabel.containsKey(l) || ((ArrayList)this.ListInstancePerLabel.get(l)).size() <= this.p || l.size() <= this.b) continue;
                    subsetsForInsertion.add(l);
                }
                instances = (ArrayList)this.ListInstancePerLabel.get(ls);
                newInstances = new ArrayList();
                for (Instance tempInstance : instances) {
                    for (LabelSet l : subsetsForInsertion) {
                        double[] temp = tempInstance.toDoubleArray();
                        double[] tempLabels = l.toDoubleArray();
                        for (int i = 0; i < this.numLabels; ++i) {
                            temp[this.labelIndices[i]] = this.format.attribute(this.labelIndices[i]).value(0).equals("0") ? tempLabels[i] : 1.0 - tempLabels[i];
                        }
                        Instance newInstance = DataUtils.createInstance(tempInstance, 1.0, temp);
                        newInstances.add(newInstance);
                    }
                }
                return newInstances;
            }
        }
        return null;
    }

    public static enum Strategy {
        A,
        B;

    }
}

