/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import mulan.core.ArgumentNullException;
import mulan.data.LabelNode;

@XmlRootElement(name="label", namespace="http://mulan.sourceforge.net/labels")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="labelType", propOrder={"childrenNodes"})
public class LabelNodeImpl
implements LabelNode,
Serializable {
    private static final long serialVersionUID = -7974176487751728557L;
    @XmlAttribute(required=true)
    private final String name;
    @XmlElement(type=LabelNodeImpl.class, name="label", namespace="http://mulan.sourceforge.net/labels")
    private final Set<LabelNode> childrenNodes;
    private LabelNode parentNode;

    public LabelNodeImpl(String name) {
        if (name == null) {
            throw new ArgumentNullException("name");
        }
        this.name = name;
        this.parentNode = null;
        this.childrenNodes = new HashSet<LabelNode>();
    }

    private LabelNodeImpl() {
        this.name = "";
        this.childrenNodes = new HashSet<LabelNode>();
    }

    public boolean addChildNode(LabelNode node) {
        if (node == null) {
            throw new ArgumentNullException("node");
        }
        if (node.getName().equals(this.name)) {
            throw new IllegalArgumentException("The child label node can not have same name as parent.");
        }
        if (!this.childrenNodes.contains(node)) {
            ((LabelNodeImpl)node).setParent(this);
        }
        return this.childrenNodes.add(node);
    }

    public boolean removeChildNode(LabelNode node) {
        if (node == null) {
            throw new ArgumentNullException("node");
        }
        if (this.childrenNodes.contains(node)) {
            for (LabelNode item : this.childrenNodes) {
                if (!item.equals(node)) continue;
                ((LabelNodeImpl)item).setParent(null);
                break;
            }
        }
        return this.childrenNodes.remove(node);
    }

    public Set<String> getChildrenLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (LabelNode child : this.childrenNodes) {
            labels.add(child.getName());
        }
        return labels;
    }

    @Override
    public Set<String> getDescendantLabels() {
        HashSet<String> labels = new HashSet<String>();
        if (this.hasChildren()) {
            for (LabelNode child : this.childrenNodes) {
                labels.addAll(this.getDescendantLabelsRec(child));
            }
        }
        return labels;
    }

    private Set<String> getDescendantLabelsRec(LabelNode node) {
        HashSet<String> labels = new HashSet<String>();
        labels.add(node.getName());
        if (node.hasChildren()) {
            for (LabelNode child : node.getChildren()) {
                labels.addAll(this.getDescendantLabelsRec(child));
            }
        }
        return labels;
    }

    @Override
    public Set<LabelNode> getChildren() {
        return Collections.unmodifiableSet(this.childrenNodes);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LabelNode getParent() {
        return this.parentNode;
    }

    protected void setParent(LabelNode node) {
        this.parentNode = node;
    }

    @Override
    public boolean hasChildren() {
        return !this.childrenNodes.isEmpty();
    }

    @Override
    public boolean hasParent() {
        return this.parentNode != null;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.name.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LabelNodeImpl labelNode = (LabelNodeImpl)obj;
        return this.name.equals(labelNode.getName());
    }
}

