/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Serializable;
import java.util.ArrayList;
import weka.core.Utils;

public class LabelSet
implements Serializable,
Comparable<LabelSet> {
    private static final long serialVersionUID = 7658871740607834759L;
    protected int[] labelSet;
    private int size = -1;

    public LabelSet(double[] set) {
        this.labelSet = new int[set.length];
        for (int i = 0; i < set.length; ++i) {
            this.labelSet[i] = (int)set[i];
        }
    }

    public String toString() {
        return this.toBitString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LabelSet) {
            LabelSet other = (LabelSet)obj;
            return other.labelSet.length == this.labelSet.length && this.hammingDifference(other) == 0;
        }
        return false;
    }

    public int size() {
        if (this.size == -1) {
            this.size = Utils.sum((int[])this.labelSet);
        }
        return this.size;
    }

    public double[] toDoubleArray() {
        double[] arr = new double[this.labelSet.length];
        for (int i = 0; i < this.labelSet.length; ++i) {
            arr[i] = this.labelSet[i];
        }
        return arr;
    }

    public boolean[] toBooleanArray() {
        boolean[] arr = new boolean[this.labelSet.length];
        for (int i = 0; i < this.labelSet.length; ++i) {
            arr[i] = this.labelSet[i] == 1;
        }
        return arr;
    }

    public int hammingDifference(LabelSet other) {
        int diff = 0;
        for (int i = 0; i < this.labelSet.length; ++i) {
            if (this.labelSet[i] == other.labelSet[i]) continue;
            ++diff;
        }
        return diff;
    }

    public String toBitString() {
        StringBuilder sb = new StringBuilder(this.labelSet.length);
        for (int i = 0; i < this.labelSet.length; ++i) {
            sb.append(Integer.toString(this.labelSet[i]));
        }
        return sb.toString();
    }

    public static LabelSet fromBitString(String bits) throws Exception {
        LabelSet result = new LabelSet(new double[bits.length()]);
        block4: for (int i = 0; i < bits.length(); ++i) {
            switch (bits.charAt(i)) {
                case '1': {
                    result.labelSet[i] = 1;
                    continue block4;
                }
                case '0': {
                    result.labelSet[i] = 0;
                    continue block4;
                }
                default: {
                    throw new Exception("Bad bitstring: " + bits);
                }
            }
        }
        return result;
    }

    public ArrayList<LabelSet> getSubsets() throws Exception {
        ArrayList<LabelSet> subsets = new ArrayList<LabelSet>();
        int powerElements = (int)Math.pow(2.0, this.size());
        for (int i = 1; i < powerElements - 1; ++i) {
            int foundDigits;
            String temp = Integer.toBinaryString(i);
            for (int j = foundDigits = temp.length(); j < this.size(); ++j) {
                temp = "0" + temp;
            }
            LabelSet tempSet = LabelSet.fromBitString(temp);
            double[] tempDouble = tempSet.toDoubleArray();
            double[] subset = new double[this.labelSet.length];
            int counter = 0;
            for (int j = 0; j < this.labelSet.length; ++j) {
                if (this.labelSet[j] == 0) {
                    subset[j] = 0.0;
                    continue;
                }
                subset[j] = tempDouble[counter];
                ++counter;
            }
            LabelSet finalLabelSet = new LabelSet(subset);
            subsets.add(finalLabelSet);
        }
        return subsets;
    }

    public static LabelSet intersection(LabelSet l1, LabelSet l2) {
        double[] arrayL2;
        double[] arrayL1 = l1.toDoubleArray();
        if (arrayL1.length != (arrayL2 = l2.toDoubleArray()).length) {
            return null;
        }
        double[] intersection = new double[arrayL2.length];
        for (int i = 0; i < arrayL2.length; ++i) {
            intersection[i] = arrayL1[i] == 1.0 && arrayL2[i] == 1.0 ? 1.0 : 0.0;
        }
        return new LabelSet(intersection);
    }

    @Override
    public int compareTo(LabelSet o) {
        if (o.size() < this.size()) {
            return -1;
        }
        if (o.size() > this.size()) {
            return 1;
        }
        return 0;
    }
}

