/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import mulan.data.LabelSet;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class Statistics
implements Serializable,
TechnicalInformationHandler {
    private static final long serialVersionUID = 1206845794397561633L;
    private int numInstances;
    private int numPredictors = 0;
    private int numNominal = 0;
    private int numNumeric = 0;
    private int numLabels;
    private double labelDensity;
    private double labelCardinality;
    private double[] examplesPerLabel;
    private double[] cardinalityDistribution;
    private HashMap<LabelSet, Integer> labelsets;
    double[][] phi;

    public HashMap<LabelSet, Integer> labelCombCount() {
        return this.labelsets;
    }

    public double[][] calculateCoocurrence(MultiLabelInstances mdata) {
        Instances data = mdata.getDataSet();
        int labels = mdata.getNumLabels();
        double[][] coocurrenceMatrix = new double[labels][labels];
        this.numPredictors = data.numAttributes() - labels;
        for (int k = 0; k < data.numInstances(); ++k) {
            Instance temp = data.instance(k);
            for (int i = 0; i < labels; ++i) {
                for (int j = 0; j < labels; ++j) {
                    if (i >= j || !temp.stringValue(this.numPredictors + i).equals("1") || !temp.stringValue(this.numPredictors + j).equals("1")) continue;
                    double[] dArray = coocurrenceMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        for (int i = 0; i < labels; ++i) {
            for (int j = 0; j < labels; ++j) {
                System.out.print(coocurrenceMatrix[i][j] + "\t");
            }
            System.out.println();
        }
        return coocurrenceMatrix;
    }

    public void calculateStats(MultiLabelInstances mlData) {
        int i;
        Instances data = mlData.getDataSet();
        this.numLabels = mlData.getNumLabels();
        int[] labelIndices = mlData.getLabelIndices();
        int[] featureIndices = mlData.getFeatureIndices();
        this.numPredictors = featureIndices.length;
        this.labelCardinality = 0.0;
        this.numNominal = 0;
        this.numNumeric = 0;
        this.examplesPerLabel = new double[this.numLabels];
        this.cardinalityDistribution = new double[this.numLabels + 1];
        this.labelsets = new HashMap();
        for (i = 0; i < featureIndices.length; ++i) {
            if (data.attribute(featureIndices[i]).isNominal()) {
                ++this.numNominal;
            }
            if (!data.attribute(featureIndices[i]).isNumeric()) continue;
            ++this.numNumeric;
        }
        this.numInstances = data.numInstances();
        for (i = 0; i < this.numInstances; ++i) {
            int exampleCardinality = 0;
            double[] dblLabels = new double[this.numLabels];
            for (int j = 0; j < this.numLabels; ++j) {
                if (data.instance(i).stringValue(labelIndices[j]).equals("1")) {
                    dblLabels[j] = 1.0;
                    ++exampleCardinality;
                    this.labelCardinality += 1.0;
                    int n = j;
                    this.examplesPerLabel[n] = this.examplesPerLabel[n] + 1.0;
                    continue;
                }
                dblLabels[j] = 0.0;
            }
            int n = exampleCardinality;
            this.cardinalityDistribution[n] = this.cardinalityDistribution[n] + 1.0;
            LabelSet labelSet = new LabelSet(dblLabels);
            if (this.labelsets.containsKey(labelSet)) {
                this.labelsets.put(labelSet, this.labelsets.get(labelSet) + 1);
                continue;
            }
            this.labelsets.put(labelSet, 1);
        }
        this.labelCardinality /= (double)this.numInstances;
        this.labelDensity = this.labelCardinality / (double)this.numLabels;
        int j = 0;
        while (j < this.numLabels) {
            int n = j++;
            this.examplesPerLabel[n] = this.examplesPerLabel[n] / (double)this.numInstances;
        }
    }

    public double[][] calculatePhi(MultiLabelInstances dataSet) throws Exception {
        this.numLabels = dataSet.getNumLabels();
        int[] labelIndices = dataSet.getLabelIndices();
        this.numLabels = dataSet.getNumLabels();
        this.phi = new double[this.numLabels][this.numLabels];
        Remove remove = new Remove();
        remove.setInvertSelection(true);
        remove.setAttributeIndicesArray(labelIndices);
        remove.setInputFormat(dataSet.getDataSet());
        Instances result = Filter.useFilter((Instances)dataSet.getDataSet(), (Filter)remove);
        result.setClassIndex(result.numAttributes() - 1);
        for (int i = 0; i < this.numLabels; ++i) {
            int[] a = new int[this.numLabels];
            int[] b = new int[this.numLabels];
            int[] c = new int[this.numLabels];
            int[] d = new int[this.numLabels];
            double[] e = new double[this.numLabels];
            double[] f = new double[this.numLabels];
            double[] g = new double[this.numLabels];
            double[] h = new double[this.numLabels];
            for (int j = 0; j < result.numInstances(); ++j) {
                for (int l = 0; l < this.numLabels; ++l) {
                    if (result.instance(j).stringValue(i).equals("0")) {
                        if (result.instance(j).stringValue(l).equals("0")) {
                            int n = l;
                            a[n] = a[n] + 1;
                            continue;
                        }
                        int n = l;
                        c[n] = c[n] + 1;
                        continue;
                    }
                    if (result.instance(j).stringValue(l).equals("0")) {
                        int n = l;
                        b[n] = b[n] + 1;
                        continue;
                    }
                    int n = l;
                    d[n] = d[n] + 1;
                }
            }
            for (int l = 0; l < this.numLabels; ++l) {
                e[l] = a[l] + b[l];
                f[l] = c[l] + d[l];
                g[l] = a[l] + c[l];
                h[l] = b[l] + d[l];
                double mult = e[l] * f[l] * g[l] * h[l];
                double denominator = Math.sqrt(mult);
                double nominator = a[l] * d[l] - b[l] * c[l];
                this.phi[i][l] = nominator / denominator;
            }
        }
        return this.phi;
    }

    public void printPhiCorrelations() {
        String pattern = "0.00";
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        for (int i = 0; i < this.numLabels; ++i) {
            for (int j = 0; j < this.numLabels; ++j) {
                System.out.print(myFormatter.format(this.phi[i][j]) + " ");
            }
            System.out.println("");
        }
    }

    public double[] getPhiHistogram() {
        double[] pairs = new double[this.numLabels * (this.numLabels - 1) / 2];
        int counter = 0;
        for (int i = 0; i < this.numLabels - 1; ++i) {
            for (int j = i + 1; j < this.numLabels; ++j) {
                pairs[counter] = this.phi[i][j];
                ++counter;
            }
        }
        return pairs;
    }

    public int[] uncorrelatedLabels(int labelIndex, double bound) {
        ArrayList<Integer> indiceslist = new ArrayList<Integer>();
        for (int i = 0; i < this.numLabels; ++i) {
            if (!(Math.abs(this.phi[labelIndex][i]) <= bound)) continue;
            indiceslist.add(i);
        }
        int[] indices = new int[indiceslist.size()];
        for (int i = 0; i < indiceslist.size(); ++i) {
            indices[i] = (Integer)indiceslist.get(i);
        }
        return indices;
    }

    public int[] topPhiCorrelatedLabels(int labelIndex, int k) {
        double[] absCorrelations = new double[this.numLabels];
        for (int i = 0; i < this.numLabels; ++i) {
            absCorrelations[i] = Math.abs(this.phi[labelIndex][i]);
        }
        int[] sorted = Utils.stableSort((double[])absCorrelations);
        int[] topPhiCorrelated = new int[k + 1];
        for (int i = 0; i < k; ++i) {
            topPhiCorrelated[i] = sorted[this.numLabels - 1 - i];
        }
        topPhiCorrelated[k] = this.numLabels;
        return topPhiCorrelated;
    }

    public void printPhiDiagram(double step) {
        String pattern = "0.00";
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        System.out.println("Phi      AvgCorrelated");
        for (double tempPhi = 0.0; tempPhi <= 1.001; tempPhi += step) {
            double avgCorrelated = 0.0;
            for (int i = 0; i < this.numLabels; ++i) {
                int[] temp = this.uncorrelatedLabels(i, tempPhi);
                avgCorrelated += (double)(this.numLabels - temp.length);
            }
            System.out.println(myFormatter.format(this.phi) + "     " + (avgCorrelated /= (double)this.numLabels));
        }
    }

    public String toString() {
        int j;
        StringBuilder sb = new StringBuilder();
        sb.append("Examples: ").append(this.numInstances).append("\n");
        sb.append("Predictors: ").append(this.numPredictors).append("\n");
        sb.append("--Nominal: ").append(this.numNominal).append("\n");
        sb.append("--Numeric: ").append(this.numNumeric).append("\n");
        sb.append("Labels: ").append(this.numLabels).append("\n");
        sb.append("\n");
        sb.append("Cardinality: ").append(this.labelCardinality).append("\n");
        sb.append("Density: ").append(this.labelDensity).append("\n");
        sb.append("Distinct Labelsets: ").append(this.labelsets.size()).append("\n");
        sb.append("\n");
        for (j = 0; j < this.numLabels; ++j) {
            sb.append("Percentage of examples with label ").append(j + 1).append(": ").append(this.examplesPerLabel[j]).append("\n");
        }
        sb.append("\n");
        for (j = 0; j <= this.numLabels; ++j) {
            sb.append("Examples of cardinality ").append(j).append(": ").append(this.cardinalityDistribution[j]).append("\n");
        }
        sb.append("\n");
        for (LabelSet set : this.labelsets.keySet()) {
            sb.append("Examples of combination ").append(set).append(": ").append(this.labelsets.get(set)).append("\n");
        }
        return sb.toString();
    }

    public double[] priors() {
        return this.examplesPerLabel;
    }

    public double cardinality() {
        return this.labelCardinality;
    }

    public double density() {
        return this.labelDensity;
    }

    public Set<LabelSet> labelSets() {
        return this.labelsets.keySet();
    }

    public int labelFrequency(LabelSet x) {
        return this.labelsets.get(x);
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INCOLLECTION);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Tsoumakas, Grigorios and Katakis, Ioannis and Vlahavas, Ioannis");
        result.setValue(TechnicalInformation.Field.TITLE, "Mining Multi-Label Data");
        result.setValue(TechnicalInformation.Field.PAGES, "667-685");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Data Mining and Knowledge Discovery Handbook");
        result.setValue(TechnicalInformation.Field.EDITOR, "Maimon, Oded and Rokach, Lior");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        result.setValue(TechnicalInformation.Field.EDITION, "2nd");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        return result;
    }

    public String globalInfo() {
        return "Class for calculating statistics of a multi-label dataset. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

