/*
 * Decompiled with CFR 0.152.
 */
package mulan.dimensionalityReduction;

import java.util.Arrays;
import mulan.data.MultiLabelInstances;
import mulan.transformations.BinaryRelevanceTransformation;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;

public class BinaryRelevanceAttributeEvaluator
extends ASEvaluation
implements AttributeEvaluator {
    private double[] scores;
    int numLabels;
    private String CombApprMode;
    private String NormMode;
    private String ScoreMode;

    public BinaryRelevanceAttributeEvaluator(ASEvaluation ase, MultiLabelInstances mlData, String combapp, String norm, String mode) {
        this.CombApprMode = combapp;
        this.NormMode = norm;
        this.ScoreMode = mode;
        this.numLabels = mlData.getNumLabels();
        try {
            int numAttributes = mlData.getFeatureIndices().length;
            double[][] evaluations = new double[this.numLabels][numAttributes];
            BinaryRelevanceTransformation brt = new BinaryRelevanceTransformation(mlData);
            for (int i = 0; i < this.numLabels; ++i) {
                System.out.println("" + (i + 1) + "/" + (this.numLabels + 1));
                Instances labelInstances = brt.transformInstances(i);
                ase.buildEvaluator(labelInstances);
                for (int j = 0; j < numAttributes; ++j) {
                    evaluations[i][j] = ((AttributeEvaluator)ase).evaluateAttribute(j);
                }
            }
            this.scores = this.featureSelection(evaluations);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int[] rankAsc(double[] scores) {
        Object[] r = new Rank[scores.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = new Rank(scores[i], i);
        }
        Arrays.sort(r);
        int[] ranking = new int[r.length];
        for (int i = 0; i < r.length; ++i) {
            ranking[i] = ((Rank)r[i]).getIndex();
        }
        return ranking;
    }

    public int[] rankDesc(double[] scores) {
        int[] ranking = this.rankAsc(scores);
        int[] decr = new int[ranking.length];
        for (int i = 0; i < decr.length; ++i) {
            decr[i] = ranking[ranking.length - 1 - i];
        }
        return decr;
    }

    public int[] order(int[] ranking) {
        int[] order = new int[ranking.length];
        for (int i = 0; i < ranking.length; ++i) {
            order[ranking[i]] = i + 1;
        }
        return order;
    }

    public double highest(double[][] scoreList, int index) {
        double highest = scoreList[0][index];
        for (int i = 1; i < scoreList.length; ++i) {
            highest = scoreList[i][index] > highest ? scoreList[i][index] : highest;
        }
        return highest;
    }

    public double lowest(double[][] scoreList, int index) {
        double lowest = scoreList[0][index];
        for (int i = 1; i < scoreList.length; ++i) {
            lowest = scoreList[i][index] < lowest ? scoreList[i][index] : lowest;
        }
        return lowest;
    }

    public double average(double[][] scoreList, int index) {
        double sum = 0.0;
        for (int i = 0; i < scoreList.length; ++i) {
            sum += scoreList[i][index];
        }
        return sum / (double)scoreList.length;
    }

    private double[] featureSelection(double[][] evaluations) throws Exception {
        double[] combAppr;
        block17: {
            int i;
            double[][] tempScores;
            block18: {
                block16: {
                    if (!this.NormMode.equalsIgnoreCase("none")) {
                        int i2;
                        if (this.NormMode.equalsIgnoreCase("dm")) {
                            for (i2 = 0; i2 < evaluations.length; ++i2) {
                                evaluations[i2] = BinaryRelevanceAttributeEvaluator.dm(evaluations[i2]);
                            }
                        } else if (this.NormMode.equalsIgnoreCase("dl")) {
                            for (i2 = 0; i2 < evaluations.length; ++i2) {
                                evaluations[i2] = BinaryRelevanceAttributeEvaluator.dl(evaluations[i2]);
                            }
                        }
                    }
                    tempScores = new double[this.numLabels][];
                    if (this.ScoreMode.equalsIgnoreCase("rank")) {
                        int[][] ranks = new int[this.numLabels][];
                        for (i = 0; i < evaluations.length; ++i) {
                            ranks[i] = this.rankDesc(evaluations[i]);
                            this.order(ranks[i]);
                        }
                        for (i = 0; i < ranks.length; ++i) {
                            tempScores[i] = new double[ranks[i].length];
                            for (int j = 0; j < ranks[i].length; ++j) {
                                tempScores[i][j] = ranks[i].length - 1 + ranks[i][j];
                            }
                        }
                    } else if (this.ScoreMode.equalsIgnoreCase("eval")) {
                        for (int i3 = 0; i3 < evaluations.length; ++i3) {
                            tempScores[i3] = Arrays.copyOf(evaluations[i3], evaluations[i3].length);
                        }
                    }
                    combAppr = new double[tempScores[0].length];
                    if (!this.CombApprMode.equalsIgnoreCase("max")) break block16;
                    for (i = 0; i < combAppr.length; ++i) {
                        combAppr[i] = this.highest(tempScores, i);
                    }
                    break block17;
                }
                if (!this.CombApprMode.equalsIgnoreCase("min")) break block18;
                for (i = 0; i < combAppr.length; ++i) {
                    combAppr[i] = this.lowest(tempScores, i);
                }
                break block17;
            }
            if (!this.CombApprMode.equalsIgnoreCase("avg")) break block17;
            for (i = 0; i < combAppr.length; ++i) {
                combAppr[i] = this.average(tempScores, i);
            }
        }
        return combAppr;
    }

    public static double norm(double[] vector) {
        double sumsq = 0.0;
        for (int i = 0; i < vector.length; ++i) {
            sumsq += Math.pow(vector[i], 2.0);
        }
        return Math.sqrt(sumsq);
    }

    public static void normalize(double[] array) {
        double max = array[0];
        for (int i = 1; i < array.length; ++i) {
            max = array[i] > max ? array[i] : max;
        }
        int j = 0;
        while (j < array.length) {
            int n = j++;
            array[n] = array[n] / max;
        }
    }

    public static double[] dl(double[] array) {
        double[] copy = new double[array.length];
        copy = Arrays.copyOf(array, array.length);
        double norm = BinaryRelevanceAttributeEvaluator.norm(copy);
        int i = 0;
        while (i < copy.length) {
            int n = i++;
            copy[n] = copy[n] / norm;
        }
        return copy;
    }

    public static double[] dm(double[] array) {
        double[] copy = new double[array.length];
        copy = Arrays.copyOf(array, array.length);
        BinaryRelevanceAttributeEvaluator.normalize(copy);
        return copy;
    }

    public double evaluateAttribute(int attribute) throws Exception {
        return this.scores[attribute];
    }

    public void buildEvaluator(Instances data) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public class Rank
    implements Comparable {
        private double score;
        private int index;

        public Rank(double score, int index) {
            this.score = score;
            this.index = index;
        }

        public double getScore() {
            return this.score;
        }

        public int getIndex() {
            return this.index;
        }

        public int compareTo(Object o) {
            if (this.score > ((Rank)o).score) {
                return 1;
            }
            if (this.score < ((Rank)o).score) {
                return -1;
            }
            return 0;
        }
    }
}

