/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.loss;

import java.io.Serializable;
import mulan.classifier.MultiLabelOutput;
import mulan.core.ArgumentNullException;
import mulan.evaluation.loss.BipartitionLossFunction;

public abstract class BipartitionLossFunctionBase
implements BipartitionLossFunction,
Serializable {
    private void checkBipartition(boolean[] bipartition) {
        if (bipartition == null) {
            throw new ArgumentNullException("Bipartition is null");
        }
    }

    private void checkLength(boolean[] bipartition, boolean[] groundTruth) {
        if (bipartition.length != groundTruth.length) {
            throw new IllegalArgumentException("The dimensions of the bipartition and the ground truth array do not match");
        }
    }

    @Override
    public final double computeLoss(MultiLabelOutput prediction, boolean[] groundTruth) {
        boolean[] bipartition = prediction.getBipartition();
        this.checkBipartition(bipartition);
        this.checkLength(bipartition, groundTruth);
        return this.computeLoss(bipartition, groundTruth);
    }

    @Override
    public abstract double computeLoss(boolean[] var1, boolean[] var2);
}

