/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.loss;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mulan.data.LabelNode;
import mulan.data.LabelsMetaData;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.loss.BipartitionLossFunctionBase;

public class HierarchicalLoss
extends BipartitionLossFunctionBase {
    private LabelsMetaData metaData;
    private Map<String, Integer> labelPosition;
    private double loss;

    public HierarchicalLoss(MultiLabelInstances data) {
        this.metaData = data.getLabelsMetaData();
        this.labelPosition = new HashMap<String, Integer>();
        int[] indices = data.getLabelIndices();
        int counter = 0;
        for (int i : indices) {
            this.labelPosition.put(data.getDataSet().attribute(i).name(), counter);
            ++counter;
        }
    }

    @Override
    public String getName() {
        return "Hierarchical Loss";
    }

    @Override
    public double computeLoss(boolean[] bipartition, boolean[] truth) {
        this.loss = 0.0;
        this.calculateHLoss(bipartition, truth, this.metaData.getRootLabels());
        return this.loss;
    }

    private void calculateHLoss(boolean[] bipartition, boolean[] truth, Set<LabelNode> children) {
        for (LabelNode child : children) {
            int labelPos = this.labelPosition.get(child.getName());
            if (bipartition[labelPos] == truth[labelPos]) {
                this.calculateHLoss(bipartition, truth, child.getChildren());
                continue;
            }
            this.loss += 1.0;
        }
    }
}

