/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.loss;

import java.util.ArrayList;
import java.util.Iterator;
import mulan.evaluation.loss.ErrorSetSize;

public class RankingLoss
extends ErrorSetSize {
    @Override
    public String getName() {
        return "Ranking Loss";
    }

    @Override
    public double computeLoss(int[] ranking, boolean[] groundTruth) {
        int numLabels = groundTruth.length;
        ArrayList<Integer> trueIndexes = new ArrayList<Integer>();
        ArrayList<Integer> falseIndexes = new ArrayList<Integer>();
        for (int labelIndex = 0; labelIndex < numLabels; ++labelIndex) {
            if (groundTruth[labelIndex]) {
                trueIndexes.add(labelIndex);
                continue;
            }
            falseIndexes.add(labelIndex);
        }
        if (!trueIndexes.isEmpty() && !falseIndexes.isEmpty()) {
            int rolp = 0;
            Iterator i$ = trueIndexes.iterator();
            while (i$.hasNext()) {
                int k = (Integer)i$.next();
                Iterator i$2 = falseIndexes.iterator();
                while (i$2.hasNext()) {
                    int l = (Integer)i$2.next();
                    if (ranking[k] <= ranking[l]) continue;
                    ++rolp;
                }
            }
            return (double)rolp / (double)(trueIndexes.size() * falseIndexes.size());
        }
        return 0.0;
    }
}

