/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.evaluation.measure.ExampleBasedBipartitionMeasureBase;
import mulan.evaluation.measure.InformationRetrievalMeasures;

public class ExampleBasedFMeasure
extends ExampleBasedBipartitionMeasureBase {
    private final double beta;

    public ExampleBasedFMeasure() {
        this(1.0);
    }

    public ExampleBasedFMeasure(double beta) {
        this.beta = beta;
    }

    @Override
    public String getName() {
        return "Example-Based F Measure";
    }

    @Override
    public double getIdealValue() {
        return 1.0;
    }

    @Override
    protected void updateBipartition(boolean[] bipartition, boolean[] truth) {
        double tp = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        for (int i = 0; i < truth.length; ++i) {
            if (bipartition[i] && truth[i]) {
                tp += 1.0;
            }
            if (bipartition[i] && !truth[i]) {
                fp += 1.0;
            }
            if (bipartition[i] || !truth[i]) continue;
            fn += 1.0;
        }
        this.sum += InformationRetrievalMeasures.fMeasure(tp, fp, fn, this.beta);
        ++this.count;
    }
}

