/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.evaluation.measure.InformationRetrievalMeasures;
import mulan.evaluation.measure.LabelBasedRecall;
import mulan.evaluation.measure.MacroAverageMeasure;

public class MacroRecall
extends LabelBasedRecall
implements MacroAverageMeasure {
    public MacroRecall(int numOfLabels) {
        super(numOfLabels);
    }

    @Override
    public double getValue() {
        double sum = 0.0;
        int count = 0;
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            sum += InformationRetrievalMeasures.recall(this.truePositives[labelIndex], this.falsePositives[labelIndex], this.falseNegatives[labelIndex]);
            ++count;
        }
        return sum / (double)count;
    }

    @Override
    public String getName() {
        return "Macro-averaged Recall";
    }

    @Override
    public double getValue(int labelIndex) {
        return InformationRetrievalMeasures.recall(this.truePositives[labelIndex], this.falsePositives[labelIndex], this.falseNegatives[labelIndex]);
    }
}

