/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import java.util.Collections;
import mulan.evaluation.measure.LabelBasedAveragePrecision;
import mulan.evaluation.measure.MacroAverageMeasure;
import weka.core.Utils;

public class MeanAverageInterpolatedPrecision
extends LabelBasedAveragePrecision
implements MacroAverageMeasure {
    private int numRecallLevels;

    public MeanAverageInterpolatedPrecision(int numOfLabels, int numRecallLevels) {
        super(numOfLabels);
        this.numRecallLevels = numRecallLevels;
    }

    @Override
    public String getName() {
        return "Mean Average Interpolated Precision";
    }

    @Override
    public double getValue() {
        double miap = 0.0;
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            miap += this.getValue(labelIndex);
        }
        return miap /= (double)this.numOfLabels;
    }

    @Override
    public double getValue(int labelIndex) {
        Boolean actual;
        int i;
        double[] precisions = new double[this.confact[labelIndex].size()];
        double[] recalls = new double[this.confact[labelIndex].size()];
        double[] interpolatedPrecision = new double[this.numRecallLevels];
        Collections.sort(this.confact[labelIndex], Collections.reverseOrder());
        double retrievedCounter = 0.0;
        double relevantCounter = 0.0;
        double totalRelevantCounter = 0.0;
        for (i = 0; i < this.confact[labelIndex].size(); ++i) {
            retrievedCounter += 1.0;
            actual = ((LabelBasedAveragePrecision.ConfidenceActual)this.confact[labelIndex].get(i)).getActual();
            if (actual.booleanValue()) {
                relevantCounter += 1.0;
            }
            precisions[i] = relevantCounter / retrievedCounter;
            totalRelevantCounter = relevantCounter;
        }
        relevantCounter = 0.0;
        for (i = 0; i < this.confact[labelIndex].size(); ++i) {
            actual = ((LabelBasedAveragePrecision.ConfidenceActual)this.confact[labelIndex].get(i)).getActual();
            if (actual.booleanValue()) {
                relevantCounter += 1.0;
            }
            recalls[i] = relevantCounter / totalRelevantCounter;
        }
        for (i = 0; i < this.numRecallLevels; ++i) {
            double recallLevel = (double)i / (double)(this.numRecallLevels - 1);
            int pos = this.findRecallPosition(recallLevel, recalls);
            interpolatedPrecision[i] = this.highestPrecisionAfterPos(pos, precisions);
        }
        double averageInterpolatedPrecision = Utils.mean((double[])interpolatedPrecision);
        return averageInterpolatedPrecision;
    }

    @Override
    public double getIdealValue() {
        return 1.0;
    }

    private double highestPrecisionAfterPos(int pos, double[] precisions) {
        double maxPrecision = precisions[pos];
        for (int i = pos + 1; i < precisions.length; ++i) {
            if (!(precisions[i] > maxPrecision)) continue;
            maxPrecision = precisions[i];
        }
        return maxPrecision;
    }

    private int findRecallPosition(double recallLevel, double[] recalls) {
        int pos = -1;
        for (int i = 0; i < recalls.length; ++i) {
            if (!(recalls[i] >= recallLevel)) continue;
            pos = i;
            break;
        }
        return pos;
    }
}

