/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.lazy.MLkNN;
import mulan.classifier.meta.RAkEL;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.InvalidDataFormatException;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluator;
import mulan.evaluation.MultipleEvaluation;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Utils;

public class CrossValidationExperiment {
    public static void main(String[] args) {
        try {
            String arffFilename = Utils.getOption((String)"arff", (String[])args);
            String xmlFilename = Utils.getOption((String)"xml", (String[])args);
            System.out.println("Loading the dataset...");
            MultiLabelInstances dataset = new MultiLabelInstances(arffFilename, xmlFilename);
            RAkEL learner1 = new RAkEL(new LabelPowerset((Classifier)new J48()));
            MLkNN learner2 = new MLkNN();
            Evaluator eval = new Evaluator();
            int numFolds = 10;
            MultipleEvaluation results = eval.crossValidate(learner1, dataset, numFolds);
            System.out.println(results);
            results = eval.crossValidate(learner2, dataset, numFolds);
            System.out.println(results);
        }
        catch (InvalidDataFormatException ex) {
            Logger.getLogger(CrossValidationExperiment.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(CrossValidationExperiment.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

