/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import java.util.Arrays;
import java.util.List;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.meta.EnsembleOfSubsetLearners;
import mulan.classifier.meta.SubsetLearner;
import mulan.classifier.transformation.LabelPowerset;
import mulan.data.ConditionalDependenceIdentifier;
import mulan.data.GreedyLabelClustering;
import mulan.data.MultiLabelInstances;
import mulan.data.UnconditionalChiSquareIdentifier;
import mulan.evaluation.Evaluation;
import mulan.evaluation.Evaluator;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Utils;

public class SubsetLearnerExamples {
    public static void main(String[] args) throws Exception {
        String path = Utils.getOption((String)"path", (String[])args);
        String filestem = Utils.getOption((String)"filestem", (String[])args);
        System.out.println("Loading the training set");
        MultiLabelInstances train = new MultiLabelInstances(path + filestem + "-train.arff", path + filestem + ".xml");
        System.out.println("Loading the test set");
        MultiLabelInstances test = new MultiLabelInstances(path + filestem + "-test.arff", path + filestem + ".xml");
        String[] methodsToCompare = new String[]{"GreedyLabelClustering-U", "EnsembleOfSubsetLearners-U", "GreedyLabelClustering-C", "EnsembleOfSubsetLearners-C", "SubsetLearner", "UnconditionalLDI", "ConditionalLDI"};
        Evaluator eval = new Evaluator();
        for (String aMethodsToCompare : methodsToCompare) {
            Object[] pairs;
            EnsembleOfSubsetLearners learner;
            ConditionalDependenceIdentifier cond;
            long testTime;
            long trainTime;
            long s3;
            Evaluation results;
            long s2;
            long s1;
            SubsetLearner learner2;
            GreedyLabelClustering clusterer;
            LabelPowerset lp;
            UnconditionalChiSquareIdentifier uncond;
            if (aMethodsToCompare.equals("GreedyLabelClustering-U")) {
                System.out.println("\nStarting GreedyLabelClustering algorithm using Unconditional labels dependence identification");
                uncond = new UnconditionalChiSquareIdentifier();
                lp = new LabelPowerset((Classifier)new J48());
                clusterer = new GreedyLabelClustering(lp, (Classifier)new J48(), uncond);
                learner2 = new SubsetLearner(clusterer, (MultiLabelLearner)lp, (Classifier)new J48());
                learner2.setUseCache(true);
                learner2.setDebug(true);
                s1 = System.currentTimeMillis();
                learner2.build(train);
                s2 = System.currentTimeMillis();
                results = eval.evaluate(learner2, test);
                s3 = System.currentTimeMillis();
                trainTime = s2 - s1;
                testTime = s3 - s2;
                System.out.println(results.toCSV());
                System.out.println("Train time: " + trainTime + " Test time: " + testTime);
            }
            if (aMethodsToCompare.equals("GreedyLabelClustering-C")) {
                System.out.println("\nStarting GreedyLabelClustering algorithm using Conditional labels dependence identification");
                cond = new ConditionalDependenceIdentifier((Classifier)new J48());
                lp = new LabelPowerset((Classifier)new J48());
                clusterer = new GreedyLabelClustering(lp, (Classifier)new J48(), cond);
                learner2 = new SubsetLearner(clusterer, (MultiLabelLearner)lp, (Classifier)new J48());
                learner2.setUseCache(true);
                learner2.setDebug(true);
                s1 = System.currentTimeMillis();
                learner2.build(train);
                s2 = System.currentTimeMillis();
                results = eval.evaluate(learner2, test);
                s3 = System.currentTimeMillis();
                trainTime = s2 - s1;
                testTime = s3 - s2;
                System.out.println(results.toCSV());
                System.out.println("Train time: " + trainTime + " Test time: " + testTime);
            }
            if (aMethodsToCompare.equals("EnsembleOfSubsetLearners-U")) {
                System.out.println("\nStarting EnsembleOfSubsetLearners algorithm using Unconditional labels dependence identification");
                uncond = new UnconditionalChiSquareIdentifier();
                lp = new LabelPowerset((Classifier)new J48());
                learner = new EnsembleOfSubsetLearners(lp, (Classifier)new J48(), uncond, 10);
                learner.setDebug(true);
                learner.setUseSubsetLearnerCache(true);
                s1 = System.currentTimeMillis();
                learner.build(train);
                s2 = System.currentTimeMillis();
                results = eval.evaluate(learner, test);
                s3 = System.currentTimeMillis();
                trainTime = s2 - s1;
                testTime = s3 - s2;
                System.out.println(results.toCSV());
                System.out.println("Train time: " + trainTime + " Test time: " + testTime);
            }
            if (aMethodsToCompare.equals("EnsembleOfSubsetLearners-C")) {
                System.out.println("\nStarting EnsembleOfSubsetLearners algorithm using Conditional labels dependence identification");
                cond = new ConditionalDependenceIdentifier((Classifier)new J48());
                lp = new LabelPowerset((Classifier)new J48());
                learner = new EnsembleOfSubsetLearners(lp, (Classifier)new J48(), cond, 10);
                learner.setDebug(true);
                learner.setUseSubsetLearnerCache(true);
                learner.setSelectDiverseModels(false);
                s1 = System.currentTimeMillis();
                learner.build(train);
                s2 = System.currentTimeMillis();
                System.out.println("Evaluation started. ");
                results = eval.evaluate(learner, test);
                s3 = System.currentTimeMillis();
                trainTime = s2 - s1;
                testTime = s3 - s2;
                System.out.println(results.toCSV());
                System.out.println("Train time: " + trainTime + " Test time: " + testTime);
            }
            if (aMethodsToCompare.equals("SubsetLearner")) {
                System.out.println("\nStarting SubsetLearner algorithm with random label set partition.");
                EnsembleOfSubsetLearners ensemble = new EnsembleOfSubsetLearners();
                List<int[][]> randomSet = ensemble.createRandomSets(train.getNumLabels(), 1);
                int[][] partition = randomSet.get(0);
                System.out.println("Random partition: " + EnsembleOfSubsetLearners.partitionToString(partition));
                learner2 = new SubsetLearner(partition, (Classifier)new J48());
                learner2.setDebug(true);
                s1 = System.currentTimeMillis();
                learner2.build(train);
                s2 = System.currentTimeMillis();
                results = eval.evaluate(learner2, test);
                s3 = System.currentTimeMillis();
                trainTime = s2 - s1;
                testTime = s3 - s2;
                System.out.println(results.toCSV());
                System.out.println("Train time: " + trainTime + " Test time: " + testTime);
            }
            if (aMethodsToCompare.equals("UnconditionalLDI")) {
                System.out.println("\nStarting algorithm for Unconditional labels dependence identification.");
                uncond = new UnconditionalChiSquareIdentifier();
                s1 = System.currentTimeMillis();
                pairs = uncond.calculateDependence(train);
                s2 = System.currentTimeMillis();
                testTime = s2 - s1;
                System.out.println("Identified dependency scores of label pairs: \n" + Arrays.toString(pairs));
                System.out.println("Computation time: " + testTime);
            }
            if (!aMethodsToCompare.equals("ConditionalLDI")) continue;
            System.out.println("\nStarting algorithm for Conditional labels dependence identification.");
            cond = new ConditionalDependenceIdentifier((Classifier)new J48());
            s1 = System.currentTimeMillis();
            pairs = cond.calculateDependence(train);
            s2 = System.currentTimeMillis();
            testTime = s2 - s1;
            System.out.println("Identified dependency scores of label pairs: \n" + Arrays.toString(pairs));
            System.out.println("Computation time: " + testTime);
        }
    }
}

