/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.segmentation;

import java.io.InputStream;
import net.sf.okapi.common.ReferenceParameter;
import net.sf.okapi.common.StringParameters;

public class Parameters
extends StringParameters {
    public static int TRIM_DEFAULT = -1;
    public static int TRIM_NO = 0;
    public static int TRIM_YES = 1;
    private static final String FORCESEGMENTEDOUTPUT = "forceSegmentedOutput";
    private static final String OVERWRITESEGMENTATION = "overwriteSegmentation";
    private static final String DEEPENSEGMENTATION = "deepenSegmentation";
    private static final String SOURCESRXPATH = "sourceSrxPath";
    private static final String TARGETSRXPATH = "targetSrxPath";
    private static final String SOURCESRX = "sourceSrx";
    private static final String TARGETSRX = "targetSrx";
    private static final String RENUMBERCODES = "renumberCodes";
    private static final String SEGMENTSOURCE = "segmentSource";
    private static final String SEGMENTTARGET = "segmentTarget";
    private static final String CHECKSEGMENTS = "checkSegments";
    private static final String TRIMSRCLEADINGWS = "trimSrcLeadingWS";
    private static final String TRIMSRCTRAILINGWS = "trimSrcTrailingWS";
    private static final String TRIMTRGLEADINGWS = "trimTrgLeadingWS";
    private static final String TRIMTRGTRAILINGWS = "trimTrgTrailingWS";
    private static final String TREATISOLATEDCODESASWS = "treatIsolatedCodesAsWhitespace";
    private static final String DONOTSEGMENTIFHASTARGET = "doNotSegmentIfHasTarget";
    private InputStream sourceSrxStream;
    private InputStream targetSrxStream;

    public void reset() {
        super.reset();
        this.setSegmentSource(true);
        this.setSegmentTarget(false);
        this.setRenumberCodes(false);
        this.setSourceSrxPath(null);
        this.setTargetSrxPath(null);
        this.setSourceSrx(null);
        this.setTargetSrx(null);
        this.setSourceSrxStream(null);
        this.setTargetSrxStream(null);
        this.setCheckSegments(false);
        this.setTrimSrcLeadingWS(TRIM_DEFAULT);
        this.setTrimSrcTrailingWS(TRIM_DEFAULT);
        this.setTrimTrgLeadingWS(TRIM_DEFAULT);
        this.setTrimTrgTrailingWS(TRIM_DEFAULT);
        this.setForcesegmentedOutput(true);
        this.setOverwriteSegmentation(false);
        this.setDeepenSegmentation(false);
        this.setTreatIsolatedCodesAsWhitespace(false);
        this.setDoNotSegmentIfHasTarget(false);
    }

    public boolean getOverwriteSegmentation() {
        return this.getBoolean(OVERWRITESEGMENTATION);
    }

    public void setOverwriteSegmentation(boolean overwriteSegmentation) {
        this.setBoolean(OVERWRITESEGMENTATION, overwriteSegmentation);
    }

    public boolean getDeepenSegmentation() {
        return this.getBoolean(DEEPENSEGMENTATION);
    }

    public void setDeepenSegmentation(boolean deepenSegmentation) {
        this.setBoolean(DEEPENSEGMENTATION, deepenSegmentation);
    }

    public boolean getForcesegmentedOutput() {
        return this.getBoolean(FORCESEGMENTEDOUTPUT);
    }

    public void setForcesegmentedOutput(boolean forceSegmentedOutput) {
        this.setBoolean(FORCESEGMENTEDOUTPUT, forceSegmentedOutput);
    }

    public void setSourceSrxPath(String sourceSrxPath) {
        this.setString(SOURCESRXPATH, sourceSrxPath);
    }

    @ReferenceParameter
    public String getSourceSrxPath() {
        return this.getString(SOURCESRXPATH);
    }

    public void setTargetSrxPath(String targetSrxPath) {
        this.setString(TARGETSRXPATH, targetSrxPath);
    }

    @ReferenceParameter
    public String getTargetSrxPath() {
        return this.getString(TARGETSRXPATH);
    }

    public void setSourceSrx(String sourceSrx) {
        this.setString(SOURCESRX, sourceSrx);
    }

    public String getSourceSrx() {
        return this.getString(SOURCESRX);
    }

    public void setTargetSrx(String targetSrx) {
        this.setString(TARGETSRX, targetSrx);
    }

    public String getTargetSrx() {
        return this.getString(TARGETSRX);
    }

    public boolean getRenumberCodes() {
        return this.getBoolean(RENUMBERCODES);
    }

    public void setRenumberCodes(boolean renumberCodes) {
        this.setBoolean(RENUMBERCODES, renumberCodes);
    }

    public boolean getSegmentSource() {
        return this.getBoolean(SEGMENTSOURCE);
    }

    public void setSegmentSource(boolean segmentSource) {
        this.setBoolean(SEGMENTSOURCE, segmentSource);
    }

    public boolean getSegmentTarget() {
        return this.getBoolean(SEGMENTTARGET);
    }

    public void setSegmentTarget(boolean segmentTarget) {
        this.setBoolean(SEGMENTTARGET, segmentTarget);
    }

    public boolean getCheckSegments() {
        return this.getBoolean(CHECKSEGMENTS);
    }

    public void setCheckSegments(boolean checkSegments) {
        this.setBoolean(CHECKSEGMENTS, checkSegments);
    }

    public int getTrimSrcLeadingWS() {
        return this.getInteger(TRIMSRCLEADINGWS);
    }

    public void setTrimSrcLeadingWS(int trimSrcLeadingWS) {
        this.setInteger(TRIMSRCLEADINGWS, trimSrcLeadingWS);
    }

    public int getTrimSrcTrailingWS() {
        return this.getInteger(TRIMSRCTRAILINGWS);
    }

    public void setTrimSrcTrailingWS(int trimSrcTrailingWS) {
        this.setInteger(TRIMSRCTRAILINGWS, trimSrcTrailingWS);
    }

    public int getTrimTrgLeadingWS() {
        return this.getInteger(TRIMTRGLEADINGWS);
    }

    public void setTrimTrgLeadingWS(int trimTrgLeadingWS) {
        this.setInteger(TRIMTRGLEADINGWS, trimTrgLeadingWS);
    }

    public int getTrimTrgTrailingWS() {
        return this.getInteger(TRIMTRGTRAILINGWS);
    }

    public void setTrimTrgTrailingWS(int trimTrgTrailingWS) {
        this.setInteger(TRIMTRGTRAILINGWS, trimTrgTrailingWS);
    }

    public boolean isTreatIsolatedCodesAsWhitespace() {
        return this.getBoolean(TREATISOLATEDCODESASWS);
    }

    public void setTreatIsolatedCodesAsWhitespace(boolean value) {
        this.setBoolean(TREATISOLATEDCODESASWS, value);
    }

    public SegmStrategy getSegmentationStrategy() {
        if (!this.getOverwriteSegmentation() && this.getDeepenSegmentation()) {
            return SegmStrategy.DEEPEN_EXISTING;
        }
        if (this.getOverwriteSegmentation()) {
            return SegmStrategy.OVERWRITE_EXISTING;
        }
        return SegmStrategy.KEEP_EXISTING;
    }

    public void setSegmentationStrategy(SegmStrategy strategy) {
        if (strategy == SegmStrategy.DEEPEN_EXISTING) {
            this.setOverwriteSegmentation(false);
            this.setDeepenSegmentation(true);
        } else if (strategy == SegmStrategy.OVERWRITE_EXISTING) {
            this.setOverwriteSegmentation(true);
            this.setDeepenSegmentation(false);
        } else {
            this.setOverwriteSegmentation(false);
            this.setDeepenSegmentation(false);
        }
    }

    public InputStream getTargetSrxStream() {
        return this.targetSrxStream;
    }

    public void setTargetSrxStream(InputStream targetSrxStream) {
        this.targetSrxStream = targetSrxStream;
    }

    public InputStream getSourceSrxStream() {
        return this.sourceSrxStream;
    }

    public void setSourceSrxStream(InputStream sourceSrxStream) {
        this.sourceSrxStream = sourceSrxStream;
    }

    public boolean getDoNotSegmentIfHasTarget() {
        return this.getBoolean(DONOTSEGMENTIFHASTARGET);
    }

    public void setDoNotSegmentIfHasTarget(boolean doNotSegmentIfHasTarget) {
        if (!doNotSegmentIfHasTarget) {
            this.setCheckSegments(true);
        }
        this.setBoolean(DONOTSEGMENTIFHASTARGET, doNotSegmentIfHasTarget);
    }

    public static enum SegmStrategy {
        KEEP_EXISTING,
        OVERWRITE_EXISTING,
        DEEPEN_EXISTING;

    }
}

