/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.lib.extra.Component;
import net.sf.okapi.steps.tokenization.common.ILexer;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.common.LexerRule;
import net.sf.okapi.steps.tokenization.common.LexerRules;
import net.sf.okapi.steps.tokenization.tokens.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLexer
extends Component
implements ILexer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean cancelled = false;
    private LexerRules rules;

    protected abstract void lexer_init();

    protected abstract boolean lexer_hasNext();

    protected abstract Lexem lexer_next();

    protected abstract void lexer_open(String var1, LocaleId var2, Tokens var3);

    public AbstractLexer() {
        Class<? extends LexerRules> rulesClass = this.lexer_getRulesClass();
        if (rulesClass == null) {
            return;
        }
        try {
            this.rules = rulesClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.debug("Lexer rules instantialion falied: {}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.debug("Lexer rules instantialion falied: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void init() {
        this.lexer_init();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void close() {
    }

    @Override
    public LexerRules getRules() {
        Class<? extends LexerRules> classRef = this.lexer_getRulesClass();
        return classRef != null ? classRef.cast(this.rules) : null;
    }

    @Override
    public boolean hasNext() {
        return !this.cancelled && this.lexer_hasNext();
    }

    @Override
    public Lexem next() {
        if (this.cancelled) {
            return null;
        }
        return this.lexer_next();
    }

    @Override
    public void open(String text, LocaleId language, Tokens tokens) {
        this.cancelled = false;
        this.lexer_open(text, language, tokens);
    }

    @Override
    public void setRules(LexerRules rules) {
        this.rules = rules;
    }

    protected boolean checkRule(LexerRule rule, LocaleId language) {
        return rule != null && rule.supportsLanguage(language) && rule.isEnabled();
    }

    protected boolean checkRule(LexerRule rule) {
        return rule != null && rule.isEnabled();
    }

    protected Class<? extends LexerRules> lexer_getRulesClass() {
        return LexerRules.class;
    }
}

