/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.common;

import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;

public class Lexem {
    private int id;
    private String value;
    private Range range;
    private int lexerId;
    private Annotations annotations;
    private boolean deleted;
    private boolean immutable;

    public Lexem(int id, String value, Range range) {
        this.id = id;
        this.value = value;
        this.range = range;
    }

    public Lexem(int id, String value, int start, int end) {
        this(id, value, new Range(start, end));
    }

    public int getId() {
        return this.id;
    }

    public String getValue() {
        return this.value;
    }

    public Range getRange() {
        return this.range;
    }

    public int getLexerId() {
        return this.lexerId;
    }

    public void setLexerId(int lexerId) {
        this.lexerId = lexerId;
    }

    public <A extends IAnnotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return (A)this.annotations.get(type);
    }

    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    public <A extends IAnnotation> A removeAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return (A)this.annotations.remove(type);
    }

    public String toString() {
        return String.format("%-20s%4d\t%4d, %4d\t%4d", this.value, this.id, this.range.start, this.range.end, this.lexerId);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }
}

