/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.engine;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.steps.tokenization.common.AbstractLexer;
import net.sf.okapi.steps.tokenization.common.Lexem;
import net.sf.okapi.steps.tokenization.common.Lexems;
import net.sf.okapi.steps.tokenization.common.LexerRule;
import net.sf.okapi.steps.tokenization.common.LexerRules;
import net.sf.okapi.steps.tokenization.common.RegexRule;
import net.sf.okapi.steps.tokenization.common.RegexRules;
import net.sf.okapi.steps.tokenization.tokens.Tokens;

public class TextScanner
extends AbstractLexer {
    private LinkedList<Lexem> queue;
    private LinkedList<LexerRule> rulesQueue;
    private boolean hasNext;
    private LexerRules rules;
    private LinkedHashMap<LexerRule, Pattern> patterns;
    private String text;
    private LocaleId language;

    @Override
    protected Class<? extends LexerRules> lexer_getRulesClass() {
        return RegexRules.class;
    }

    @Override
    protected boolean lexer_hasNext() {
        return this.hasNext;
    }

    @Override
    protected void lexer_init() {
        this.queue = new LinkedList();
        this.rulesQueue = new LinkedList();
        this.patterns = new LinkedHashMap();
        this.rules = this.getRules();
        for (LexerRule item : this.rules) {
            RegexRule rule = (RegexRule)item;
            Pattern pattern = null;
            if (rule.getPattern() != null) {
                pattern = Pattern.compile(rule.getPattern(), rule.getRegexOptions());
            }
            this.patterns.put(rule, pattern);
        }
    }

    @Override
    protected Lexem lexer_next() {
        if (!this.queue.isEmpty()) {
            return this.queue.poll();
        }
        do {
            Pattern pattern;
            RegexRule rule = null;
            if (!this.rulesQueue.isEmpty()) {
                rule = (RegexRule)this.rulesQueue.poll();
            }
            while (rule != null && !this.checkRule(rule, this.language)) {
                if (this.rulesQueue.isEmpty()) {
                    rule = null;
                    continue;
                }
                rule = (RegexRule)this.rulesQueue.poll();
            }
            if (rule == null || (pattern = this.patterns.get((Object)rule)) == null) continue;
            Matcher matcher = pattern.matcher(this.text);
            int groupIndex = rule.getRegexGroup();
            while (matcher.find()) {
                int start = matcher.start(groupIndex);
                int end = matcher.end(groupIndex);
                if (start <= -1 || end <= -1) continue;
                this.queue.add(new Lexem(rule.getLexemId(), matcher.group(groupIndex), start, end));
            }
            return this.queue.poll();
        } while (!this.rulesQueue.isEmpty() && this.queue.isEmpty());
        this.hasNext = false;
        return null;
    }

    @Override
    protected void lexer_open(String text, LocaleId language, Tokens tokens) {
        this.text = text;
        this.language = language;
        this.queue.clear();
        this.rulesQueue.clear();
        this.rulesQueue.addAll(this.rules);
        this.hasNext = true;
    }

    @Override
    public Lexems process(String text, LocaleId language, Tokens tokens) {
        return null;
    }
}

