/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.tokens;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.steps.tokenization.common.Token;
import net.sf.okapi.steps.tokenization.tokens.Parameters;
import net.sf.okapi.steps.tokenization.tokens.TokenItem;

public class Tokens
extends ArrayList<Token> {
    private static final long serialVersionUID = 2484560539089898608L;
    private static TreeMap<Integer, TokenItem> idMap;
    private static TreeMap<String, TokenItem> nameMap;
    private static List<TokenItem> items;

    public Tokens getFilteredList(String ... tokenNames) {
        List<String> names = null;
        if (tokenNames == null || tokenNames != null && tokenNames.length == 0) {
            return this;
        }
        names = Arrays.asList(tokenNames);
        Tokens res = new Tokens();
        for (int i = 0; i < this.size(); ++i) {
            Token token = (Token)this.get(i);
            if (token == null || !names.contains(token.getName())) continue;
            res.add(token);
        }
        return res;
    }

    public void fixRanges(List<Integer> markerPositions) {
        for (Integer pos : markerPositions) {
            for (Token token : this) {
                if (token.getRange().start > pos) {
                    token.getRange().start += 2;
                }
                if (token.getRange().end <= pos) continue;
                token.getRange().end += 2;
            }
        }
    }

    @Override
    public String toString() {
        ArrayList<String> res = new ArrayList<String>();
        for (Token token : this) {
            res.add(token.toString());
        }
        return ListUtil.listAsString(res, (String)"\n");
    }

    public static int getTokenId(String tokenName) {
        if (nameMap == null) {
            return 0;
        }
        if (items == null) {
            return 0;
        }
        TokenItem item = nameMap.get(tokenName);
        return items.indexOf((Object)item) + 1;
    }

    public static String getTokenName(int tokenId) {
        if (idMap == null) {
            return "";
        }
        TokenItem item = idMap.get(tokenId);
        return item != null ? item.getName() : "";
    }

    public static String getTokenDescription(int tokenId) {
        if (idMap == null) {
            return "";
        }
        TokenItem item = idMap.get(tokenId);
        return item != null ? item.getDescription() : "";
    }

    public static String getTokenDescription(String tokenName) {
        if (nameMap == null) {
            return "";
        }
        TokenItem item = nameMap.get(tokenName);
        return item != null ? item.getDescription() : "";
    }

    public static String getTokenNamesStr() {
        if (nameMap == null) {
            return "";
        }
        return ListUtil.arrayAsString((String[])nameMap.keySet().toArray(new String[0]));
    }

    public static Collection<TokenItem> getTokenItems() {
        if (idMap == null) {
            return null;
        }
        return idMap.values();
    }

    public static List<String> getTokenNames() {
        return new ArrayList<String>(nameMap.keySet());
    }

    public static List<Integer> getTokenIDs() {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (String tokenName : nameMap.keySet()) {
            idList.add(Tokens.getTokenId(tokenName));
        }
        return idList;
    }

    public static List<Integer> getTokenIDs(List<String> tokenNames) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (tokenNames != null) {
            for (String tokenName : tokenNames) {
                idList.add(Tokens.getTokenId(tokenName));
            }
        }
        return idList;
    }

    public void setImmutable(boolean immutable) {
        for (Token token : this) {
            token.setImmutable(immutable);
        }
    }

    static {
        Parameters params = new Parameters();
        idMap = new TreeMap();
        nameMap = new TreeMap();
        if (params != null) {
            params.loadItems();
            items = params.getItems();
            if (idMap != null && items != null && nameMap != null) {
                for (int i = 0; i < items.size(); ++i) {
                    TokenItem item = items.get(i);
                    if (item == null) continue;
                    int id = i + 1;
                    idMap.put(id, item);
                    nameMap.put(item.getName(), item);
                }
            }
        }
    }
}

