/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraints;

import net.sf.oval.AbstractAnnotationCheck;
import net.sf.oval.constraints.Range;
import net.sf.oval.contexts.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeCheck
extends AbstractAnnotationCheck<Range> {
    private static final long serialVersionUID = 1L;
    private long min;
    private long max;

    @Override
    public void configure(Range constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.max());
        this.setMin(constraintAnnotation.min());
    }

    public long getMax() {
        return this.max;
    }

    @Override
    public String[] getMessageValues() {
        return new String[]{Long.toString(this.min), Long.toString(this.max)};
    }

    public long getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object value, OValContext context) {
        if (value == null) {
            return true;
        }
        if (value instanceof Number) {
            if (value instanceof Float || value instanceof Double) {
                double doubleValue = ((Number)value).doubleValue();
                return doubleValue >= (double)this.min && doubleValue <= (double)this.max;
            }
            long longValue = ((Number)value).longValue();
            return longValue >= this.min && longValue <= this.max;
        }
        String stringValue = value.toString();
        try {
            double doubleValue = Double.parseDouble(stringValue);
            return doubleValue >= (double)this.min && doubleValue <= (double)this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setMax(long max) {
        this.max = max;
    }

    public void setMin(long min) {
        this.min = min;
    }
}

