/*
 * Decompiled with CFR 0.152.
 */
package phat;

import phat.GUIArgumentProcessor;
import phat.GUIPHATInterface;
import phat.PHATInitializer;
import phat.body.BodiesAppState;
import phat.body.commands.SetBodyHeightCommand;
import phat.body.commands.SetBodyInHouseSpaceCommand;
import phat.commands.PHATCommand;
import phat.config.AgentConfigurator;
import phat.config.BodyConfigurator;
import phat.config.DeviceConfigurator;
import phat.config.HouseConfigurator;
import phat.config.ServerConfigurator;
import phat.config.WorldConfigurator;
import phat.structures.houses.HouseFactory;
import phat.world.WorldAppState;

public class GUIMainPHATSimulation
implements PHATInitializer {
    public static void main(String[] args) {
        String[] a = new String[]{"-record"};
        GUIMainPHATSimulation sim = new GUIMainPHATSimulation();
        GUIPHATInterface phat = new GUIPHATInterface(sim, new GUIArgumentProcessor(a));
        phat.setSeed(0L);
        phat.setDisplayHeight(800);
        phat.setDisplayWidth(480);
        phat.start();
    }

    public void initWorld(WorldConfigurator worldConfig) {
        worldConfig.setTime(2014, 2, 3, 14, 0, 0);
        worldConfig.setTimeVisible(true);
        worldConfig.setLandType(WorldAppState.LandType.Grass);
    }

    public void initHouse(HouseConfigurator houseConfig) {
        houseConfig.addHouseType("House1", HouseFactory.HouseType.House3room2bath);
    }

    public void initBodies(BodyConfigurator bodyConfig) {
        bodyConfig.createBody(BodiesAppState.BodyType.ElderLP, "Relative");
        bodyConfig.runCommand((PHATCommand)new SetBodyInHouseSpaceCommand("Relative", "House1", "LivingRoom"));
        bodyConfig.runCommand((PHATCommand)new SetBodyHeightCommand("Relative", 1.7f));
    }

    public void initDevices(DeviceConfigurator deviceConfig) {
    }

    public void initServer(ServerConfigurator deviceConfig) {
    }

    public void initAgents(AgentConfigurator agentsConfig) {
    }

    public String getTittle() {
        return "PHAT-" + this.getClass().getSimpleName();
    }
}

