/*
 * Decompiled with CFR 0.152.
 */
package phat.gui;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.math.Vector2f;
import phat.app.PHATApplication;
import phat.devices.DevicesAppState;
import phat.gui.eventLauncher.EventLauncherPanel;
import phat.gui.logging.LoggingViewerAppState;
import phat.gui.screenshot.GUIScreenShotAppState;
import phat.gui.time.TimeAppState;
import tonegod.gui.controls.buttons.Button;
import tonegod.gui.controls.menuing.Menu;
import tonegod.gui.controls.text.TextField;
import tonegod.gui.controls.windows.DialogBox;
import tonegod.gui.core.Element;
import tonegod.gui.core.ElementManager;
import tonegod.gui.core.Screen;
import tonegod.gui.effects.Effect;

public class GUIMainMenuAppState
extends AbstractAppState {
    Screen screen;
    Menu mainMenu;
    Menu viewMenu;
    Menu viewInfoMenu;
    Menu viewDebugMenu;
    Menu toolsMenu;
    Button menuButton;
    Button playPauseButton;
    Button speedDownButton;
    TextField speedLabel;
    Button speedUpButton;
    PHATApplication app;
    String path = "/home/pablo/Models/";
    boolean displayFps = false;
    boolean statView = false;
    EventLauncherPanel eventLauncherPanel;

    public GUIMainMenuAppState(Screen screen) {
        this.screen = screen;
        screen.parseLayout("Interface/MainMenu.gui.xml", (AbstractAppState)this);
        this.mainMenu = (Menu)screen.getElementById("MainMenu");
        this.toolsMenu = (Menu)screen.getElementById("ToolsMenu");
        this.viewMenu = (Menu)screen.getElementById("ViewMenu");
        this.viewInfoMenu = (Menu)screen.getElementById("ViewInfoMenu");
        this.viewDebugMenu = (Menu)screen.getElementById("ViewDebugMenu");
        this.menuButton = (Button)screen.getElementById("MenuButton");
        this.playPauseButton = (Button)screen.getElementById("PlayPauseButton");
        this.speedDownButton = (Button)screen.getElementById("SpeedDownButton");
        this.speedLabel = (TextField)screen.getElementById("SpeedLabel");
        this.speedUpButton = (Button)screen.getElementById("SpeedUpButton");
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = (PHATApplication)app;
        this.app.setSimSpeed(1.0f);
        this.app.setDisplayFps(this.displayFps);
        this.app.setDisplayStatView(this.statView);
    }

    public void update(float tpf) {
        super.update(tpf);
        Vector2f pos = this.screen.getMouseXY();
        if (pos.y > this.screen.getHeight() - 50.0f) {
            if (!this.menuButton.getIsVisible() && !this.mainMenu.getIsVisible()) {
                this.menuButton.showWithEffect();
                this.playPauseButton.showWithEffect();
                this.speedDownButton.showWithEffect();
                this.speedLabel.showWithEffect();
                this.speedUpButton.showWithEffect();
            }
        } else if (this.menuButton.getIsVisible()) {
            this.menuButton.hideWithEffect();
            this.playPauseButton.hideWithEffect();
            this.speedDownButton.hideWithEffect();
            this.speedLabel.hideWithEffect();
            this.speedUpButton.hideWithEffect();
        }
    }

    public void cleanup() {
        super.cleanup();
        Effect hide = new Effect(Effect.EffectType.FadeOut, Effect.EffectEvent.Hide, 0.25f);
        hide.setDestroyOnHide(true);
        this.screen.removeElement((Element)this.menuButton);
        this.screen.removeElement((Element)this.viewDebugMenu);
        this.screen.removeElement((Element)this.viewInfoMenu);
        this.screen.removeElement((Element)this.viewMenu);
        this.screen.removeElement((Element)this.toolsMenu);
        this.screen.removeElement((Element)this.mainMenu);
        this.screen.removeElement((Element)this.playPauseButton);
        this.screen.removeElement((Element)this.speedDownButton);
        this.screen.removeElement((Element)this.speedLabel);
        this.screen.removeElement((Element)this.speedUpButton);
    }

    public void showMenu(MouseButtonEvent evt, boolean isToggle) {
        System.out.println("showMenu!!!");
        this.mainMenu.showWithEffect();
    }

    public void pause() {
        this.playPauseButton.setText("Resume");
        this.app.setSimSpeed(0.0f);
    }

    public void resume() {
        this.playPauseButton.setText("Pause");
        this.app.setSimSpeed(Float.parseFloat(this.speedLabel.getText()));
    }

    public void playPauseSim(MouseButtonEvent evt, boolean isToggle) {
        if (this.playPauseButton.getText().equals("Pause")) {
            this.pause();
        } else {
            this.resume();
        }
    }

    public void onSpeedDown(MouseButtonEvent evt, boolean isToggle) {
        float speed = Float.parseFloat(this.speedLabel.getText());
        if (speed >= 0.5f) {
            this.speedLabel.setText(String.valueOf(speed /= 2.0f));
            this.onSpeedChange();
        }
    }

    public void onSpeedUp(MouseButtonEvent evt, boolean isToggle) {
        float speed = Float.parseFloat(this.speedLabel.getText());
        if (speed < 128.0f) {
            this.speedLabel.setText(String.valueOf(speed *= 2.0f));
            this.onSpeedChange();
        }
    }

    public void onSpeedChange() {
        if (this.playPauseButton.getText().equals("Pause")) {
            this.app.setSimSpeed(Float.parseFloat(this.speedLabel.getText()));
        }
    }

    public void viewInfoMenuClick(int index, Object value, boolean isToggled) {
        switch (index) {
            case 0: {
                TimeAppState timeAppState = (TimeAppState)this.app.getStateManager().getState(TimeAppState.class);
                if (timeAppState == null) {
                    timeAppState = new TimeAppState(this.screen);
                    this.app.getStateManager().attach((AppState)timeAppState);
                    break;
                }
                this.app.getStateManager().detach((AppState)timeAppState);
            }
        }
    }

    public void viewDebugMenuClick(int index, Object value, boolean isToggled) {
        System.out.println(index + ":" + value + ":" + isToggled);
        switch (index) {
            case 0: {
                this.displayFps = isToggled;
                this.app.setDisplayFps(isToggled);
                break;
            }
            case 1: {
                this.app.setDisplayStatView(isToggled);
            }
        }
    }

    public void toolsMenuClick(int index, Object value, boolean isToggled) {
        System.out.println(index + ":" + value + ":" + isToggled);
        switch (index) {
            case 0: {
                this.app.getStateManager().detach((AppState)this);
                this.takeScreenshot();
                break;
            }
            case 1: {
                LoggingViewerAppState log = (LoggingViewerAppState)this.app.getStateManager().getState(LoggingViewerAppState.class);
                if (log == null) {
                    log = new LoggingViewerAppState();
                    this.app.getStateManager().attach((AppState)this);
                }
                if (log.isShown()) {
                    log.hide();
                    break;
                }
                log.show();
                break;
            }
            case 2: {
                if (this.eventLauncherPanel == null) {
                    DevicesAppState devicesAppState = (DevicesAppState)this.app.getStateManager().getState(DevicesAppState.class);
                    if (devicesAppState == null) break;
                    EventLauncherPanel.createAndShowGUI(devicesAppState);
                    break;
                }
                this.eventLauncherPanel.setVisible(this.eventLauncherPanel.isVisible());
            }
        }
    }

    private void takeScreenshot() {
        this.app.getStateManager().attach((AppState)new GUIScreenShotAppState(this.screen));
    }

    public void menuClicked(int index, Object value, boolean isToggled) {
        switch (index) {
            case 2: {
                System.out.println("Quit!");
                float wHeight = 150.0f;
                float wWidth = 300.0f;
                DialogBox dialog = new DialogBox((ElementManager)this.screen, "QuitDialog", new Vector2f((this.screen.getWidth() - wWidth) / 2.0f, (this.screen.getHeight() - wHeight) / 2.0f), new Vector2f(wWidth, wHeight)){

                    public void onButtonCancelPressed(MouseButtonEvent mbe, boolean bln) {
                        this.screen.removeElement((Element)this);
                    }

                    public void onButtonOkPressed(MouseButtonEvent mbe, boolean bln) {
                        GUIMainMenuAppState.this.quit();
                    }
                };
                dialog.setWindowTitle("Permission!");
                dialog.setMsg("Are you sure?");
                this.screen.addElement((Element)dialog);
                dialog.hide();
                dialog.showWithEffect();
            }
        }
    }

    private void quit() {
        this.app.stop();
    }

    public boolean isDisplayFps() {
        return this.displayFps;
    }

    public void setDisplayFps(boolean displayFps) {
        this.displayFps = displayFps;
    }

    public boolean isStatView() {
        return this.statView;
    }

    public void setStatView(boolean statView) {
        this.statView = statView;
    }
}

