/*
 * Decompiled with CFR 0.152.
 */
package phat.gui;

import phat.GUIPHATInterface;
import phat.PHATInitializer;
import phat.PHATInterface;
import phat.agents.Agent;
import phat.agents.DeviceAgent;
import phat.agents.automaton.Automaton;
import phat.agents.automaton.FSM;
import phat.agents.automaton.ParallelAutomaton;
import phat.agents.automaton.Transition;
import phat.agents.automaton.conditions.AutomatonCondition;
import phat.agents.automaton.conditions.TimerFinishedCondition;
import phat.agents.automaton.devices.FSMProgramBehavior;
import phat.agents.automaton.devices.ProgState;
import phat.agents.automaton.devices.TextToSpeachAutomaton;
import phat.agents.automaton.devices.VibrateDeviceAutomaton;
import phat.config.AgentConfigurator;
import phat.config.BodyConfigurator;
import phat.config.DeviceConfigurator;
import phat.config.HouseConfigurator;
import phat.config.ServerConfigurator;
import phat.config.WorldConfigurator;
import phat.devices.commands.CreateSmartphoneCommand;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.SetDeviceOnFurnitureCommand;
import phat.structures.houses.HouseFactory;
import phat.world.WorldAppState;

public class MainGUIPHATSimulation
implements PHATInitializer {
    public static void main(String[] args) {
        MainGUIPHATSimulation sim = new MainGUIPHATSimulation();
        GUIPHATInterface phat = new GUIPHATInterface(sim);
        phat.start();
    }

    public void initWorld(WorldConfigurator worldConfig) {
        worldConfig.setTime(2014, 2, 3, 14, 0, 0);
        worldConfig.setTimeVisible(true);
        worldConfig.setLandType(WorldAppState.LandType.Grass);
    }

    public void initHouse(HouseConfigurator houseConfig) {
        houseConfig.addHouseType("House1", HouseFactory.HouseType.House3room2bath);
    }

    public void initBodies(BodyConfigurator bodyConfig) {
    }

    public void initDevices(DeviceConfigurator deviceConfig) {
        deviceConfig.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone1"));
        deviceConfig.runCommand((PHATDeviceCommand)new SetDeviceOnFurnitureCommand("Smartphone1", "House1", "Table1"));
        deviceConfig.runCommand((PHATDeviceCommand)new CreateSmartphoneCommand("Smartphone2"));
        deviceConfig.runCommand((PHATDeviceCommand)new SetDeviceOnFurnitureCommand("Smartphone2", "House1", "Table1"));
        System.out.println("");
    }

    public void initServer(ServerConfigurator deviceConfig) {
    }

    public void initAgents(AgentConfigurator agentsConfig) {
        String deviceId = "Smartphone1";
        DeviceAgent deviceAgent = new DeviceAgent(deviceId);
        ParallelAutomaton pa = new ParallelAutomaton((Agent)deviceAgent, "ParallelAutomaton");
        FSMProgramBehavior vibrate1 = new FSMProgramBehavior((Agent)deviceAgent, "FSMVibrate1"){

            protected void initProgramStates(PHATInterface phatInterface) {
                ProgState psWaiting = new ProgState(this.agent, "PSWaiting");
                ProgState psVibrating = new ProgState(this.agent, "PSVibrating");
                VibrateDeviceAutomaton vibrate = new VibrateDeviceAutomaton(this.agent, "VibrateDeviceAutomaton").setDeviceId("Smartphone1").setMillis(2000L);
                psVibrating.addTransition((Automaton)vibrate, false);
                psVibrating.addTransition((Automaton)new TextToSpeachAutomaton(this.agent, "TTS1").setDeviceId("Smartphone1").setMessage("Hello darling"), false);
                Transition waitingToVibrating = new Transition((AutomatonCondition)new TimerFinishedCondition(0, 0, 5), (Automaton)psVibrating);
                Transition vibratingToWaiting = new Transition((AutomatonCondition)new TimerFinishedCondition(0, 0, 5), (Automaton)psWaiting);
                this.registerStartState((Automaton)psWaiting);
                this.registerTransition((Automaton)psWaiting, waitingToVibrating);
                this.registerTransition((Automaton)psVibrating, vibratingToWaiting);
            }
        };
        FSMProgramBehavior vibrate2 = new FSMProgramBehavior((Agent)deviceAgent, "FSMVibrate2"){

            protected void initProgramStates(PHATInterface phatInterface) {
                ProgState psWaiting = new ProgState(this.agent, "PSWaiting");
                ProgState psVibrating = new ProgState(this.agent, "PSVibrating");
                VibrateDeviceAutomaton vibrate = new VibrateDeviceAutomaton(this.agent, "VibrateDeviceAutomaton").setDeviceId("Smartphone2").setMillis(2000L);
                psVibrating.addTransition((Automaton)vibrate, false);
                Transition waitingToVibrating = new Transition((AutomatonCondition)new TimerFinishedCondition(0, 0, 5), (Automaton)psVibrating);
                Transition vibratingToWaiting = new Transition((AutomatonCondition)new TimerFinishedCondition(0, 0, 5), (Automaton)psWaiting);
                this.registerStartState((Automaton)psWaiting);
                this.registerTransition((Automaton)psWaiting, waitingToVibrating);
                this.registerTransition((Automaton)psVibrating, vibratingToWaiting);
            }
        };
        pa.addTransition((Automaton)vibrate1, true);
        pa.addTransition((Automaton)vibrate2, true);
        deviceAgent.setAutomaton((Automaton)pa);
        agentsConfig.add((Agent)deviceAgent);
    }

    private void createDeviceAgent(String deviceId, AgentConfigurator agentsConfig, FSMProgramBehavior ... behaviors) {
        DeviceAgent deviceAgent = new DeviceAgent(deviceId);
        ParallelAutomaton pa = new ParallelAutomaton((Agent)deviceAgent, "ParallelAutomaton");
        pa.addTransition((Automaton)new FSM((Agent)deviceAgent, 0, "FSMVibrate1"), true);
        pa.addTransition((Automaton)new FSM((Agent)deviceAgent, 0, "FSMVibrate1"), true);
        deviceAgent.setAutomaton((Automaton)pa);
        agentsConfig.add((Agent)deviceAgent);
    }

    public String getTittle() {
        return "PHAT-" + this.getClass().getSimpleName();
    }
}

