/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.eventLauncher;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import phat.devices.DevicesAppState;
import phat.gui.eventLauncher.IncomingCallEventLauncherPanel;
import phat.gui.eventLauncher.TTSLauncherPanel;
import phat.gui.eventLauncher.VibrateEventLauncherPanel;

public class EventLauncherPanel
implements ItemListener {
    DevicesAppState devicesAppState;
    JFrame frame;
    JPanel cards;
    static final String VIBRATE = "Vibrate Device";
    static final String INCOMING_CALL = "Incoming Call";
    static final String TTS = "Text To Speach";

    public EventLauncherPanel(DevicesAppState devicesAppState) {
        this.devicesAppState = devicesAppState;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, (String)evt.getItem());
    }

    public static void createAndShowGUI(DevicesAppState devicesAppState) {
        JFrame frame = new JFrame("CardLayoutDemo");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
                windowEvent.getWindow().removeAll();
            }
        });
        EventLauncherPanel demo = new EventLauncherPanel(devicesAppState);
        demo.addComponentToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
    }

    public void addComponentToPane(Container pane) {
        JPanel comboBoxPane = new JPanel();
        String[] comboBoxItems = new String[]{VIBRATE, INCOMING_CALL, TTS};
        JComboBox<String> cb = new JComboBox<String>(comboBoxItems);
        cb.setEditable(false);
        cb.addItemListener(this);
        comboBoxPane.add(cb);
        VibrateEventLauncherPanel vibrateEventLauncherPanel = new VibrateEventLauncherPanel(this.devicesAppState);
        IncomingCallEventLauncherPanel incomingCallEventLauncherPanel = new IncomingCallEventLauncherPanel(this.devicesAppState);
        TTSLauncherPanel tTSLauncherPanel = new TTSLauncherPanel(this.devicesAppState);
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)vibrateEventLauncherPanel, VIBRATE);
        this.cards.add((Component)incomingCallEventLauncherPanel, INCOMING_CALL);
        this.cards.add((Component)tTSLauncherPanel, TTS);
        pane.add((Component)comboBoxPane, "First");
        pane.add((Component)this.cards, "Center");
    }

    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    public boolean isVisible() {
        return this.frame.isVisible();
    }
}

