/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.eventLauncher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import phat.devices.DevicesAppState;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.TextToSpeachCommand;

public class TTSLauncherPanel
extends JPanel {
    DevicesAppState devicesAppState;
    JComboBox deviceIds;
    JTextArea message;

    public TTSLauncherPanel(DevicesAppState devicesAppState) {
        this.devicesAppState = devicesAppState;
        this.setLayout(new BoxLayout(this, 0));
        JLabel deviceIdLabel = new JLabel("Device Id:");
        this.deviceIds = new JComboBox<Object>(devicesAppState.getDeviceIds().toArray());
        JLabel durationLabel = new JLabel("Message:");
        this.message = new JTextArea("Write device's message");
        this.message.setSize(200, 400);
        JButton sendCommand = new JButton("Send");
        sendCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String deviceId = TTSLauncherPanel.this.deviceIds.getModel().getSelectedItem().toString();
                if (TTSLauncherPanel.this.devicesAppState.getDevice(deviceId) != null) {
                    String message = TTSLauncherPanel.this.message.getText();
                    TTSLauncherPanel.this.devicesAppState.runCommand((PHATDeviceCommand)new TextToSpeachCommand(deviceId, message));
                }
            }
        });
        JPanel panel1 = new JPanel();
        panel1.add(deviceIdLabel);
        panel1.add(this.deviceIds);
        this.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.add(durationLabel);
        panel2.add(this.message);
        this.add(panel2);
        this.add(sendCommand);
    }
}

