/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.eventLauncher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phat.devices.DevicesAppState;
import phat.devices.commands.PHATDeviceCommand;
import phat.devices.commands.VibrateDeviceCommand;

public class VibrateEventLauncherPanel
extends JPanel {
    DevicesAppState devicesAppState;
    JComboBox deviceIds;
    JTextField durationTF;

    public VibrateEventLauncherPanel(DevicesAppState devicesAppState) {
        this.devicesAppState = devicesAppState;
        this.setLayout(new BoxLayout(this, 0));
        JLabel deviceIdLabel = new JLabel("Device Id:");
        this.deviceIds = new JComboBox<Object>(devicesAppState.getDeviceIds().toArray());
        JLabel durationLabel = new JLabel("Time (ms):");
        this.durationTF = new JTextField("1000");
        this.durationTF.setColumns(4);
        JButton sendCommand = new JButton("Send");
        sendCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String deviceId = VibrateEventLauncherPanel.this.deviceIds.getModel().getSelectedItem().toString();
                if (VibrateEventLauncherPanel.this.devicesAppState.getDevice(deviceId) != null) {
                    String duration = VibrateEventLauncherPanel.this.durationTF.getText();
                    int d = Integer.parseInt(duration);
                    VibrateEventLauncherPanel.this.devicesAppState.runCommand((PHATDeviceCommand)new VibrateDeviceCommand(deviceId, (long)d));
                }
            }
        });
        JPanel panel1 = new JPanel();
        panel1.add(deviceIdLabel);
        panel1.add(this.deviceIds);
        this.add(panel1);
        JPanel panel2 = new JPanel();
        panel2.add(durationLabel);
        panel2.add(this.durationTF);
        this.add(panel2);
        this.add(sendCommand);
    }
}

