/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.LogRecord;
import javax.swing.table.AbstractTableModel;
import phat.agents.AgentsAppState;
import phat.agents.automaton.Automaton;

public class LogRecordTableModel
extends AbstractTableModel {
    AgentsAppState agentsAppState;
    List<LogRecord> logRecords = new ArrayList<LogRecord>();

    public LogRecordTableModel(AgentsAppState agentsAppState) {
        this.agentsAppState = agentsAppState;
    }

    @Override
    public int getRowCount() {
        return this.logRecords.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Secs";
            }
            case 1: {
                return "SimTime";
            }
            case 2: {
                return "AgentName";
            }
            case 3: {
                return "State";
            }
            case 4: {
                return "Action";
            }
            case 5: {
                return "Type";
            }
            case 6: {
                return "FinishCondition";
            }
            case 7: {
                return "Description";
            }
        }
        return "null";
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        LogRecord log = this.logRecords.get(rowIndex);
        if (log != null) {
            Object[] params = log.getParameters();
            switch (columnIndex) {
                case 0: {
                    return Integer.parseInt((String)log.getParameters()[0]);
                }
                case 1: {
                    if (params == null) break;
                    return log.getParameters()[1];
                }
                case 2: {
                    return log.getLoggerName();
                }
                case 3: {
                    if (params == null) break;
                    return params[2];
                }
                case 4: {
                    if (params == null) break;
                    return params[3];
                }
                case 5: {
                    if (params == null) break;
                    return params[4];
                }
                case 6: {
                    if (params == null) break;
                    Automaton aut = (Automaton)params[5];
                    return aut.getFinishCondition();
                }
                case 7: {
                    return log.getMessage();
                }
            }
        }
        return "";
    }

    public void add(LogRecord logRecord) {
        this.logRecords.add(logRecord);
        int lastRow = this.logRecords.size() - 1;
        this.fireTableRowsInserted(lastRow, lastRow);
    }

    public AgentsAppState getAgentsAppState() {
        return this.agentsAppState;
    }
}

