/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.logging;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import phat.agents.Agent;
import phat.agents.AgentListener;
import phat.agents.AgentsAppState;
import phat.agents.automaton.Automaton;
import phat.agents.automaton.AutomatonListener;
import phat.app.PHATApplication;
import phat.gui.logging.LogRecordTableModel;
import phat.gui.logging.LogTableHandler;
import phat.gui.logging.LogViewerPanel;
import phat.gui.logging.PHATLogFormatter;
import phat.world.PHATCalendar;

public class LoggingViewerAppState
extends AbstractAppState
implements AutomatonListener,
AgentListener {
    PHATApplication app;
    AgentsAppState agentsAppState;
    LogRecordTableModel tableModel;
    PHATCalendar simStartTime;
    PHATCalendar simTime;
    JFrame frame;
    Map<String, Logger> loggers = new HashMap<String, Logger>();

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = (PHATApplication)app;
        this.agentsAppState = (AgentsAppState)app.getStateManager().getState(AgentsAppState.class);
        this.simTime = this.agentsAppState.getPHAInterface().getSimTime();
        this.simStartTime = new PHATCalendar(this.simTime);
        this.tableModel = new LogRecordTableModel(this.agentsAppState);
        LogTableHandler tableHandler = new LogTableHandler(this.tableModel);
        tableHandler.setLevel(Level.INFO);
        tableHandler.setFilter(null);
        FileHandler fh = null;
        try {
            fh = new FileHandler(System.currentTimeMillis() + ".log");
            PHATLogFormatter formatter = new PHATLogFormatter();
            fh.setFormatter(formatter);
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
        System.out.println("\n\n\n***************************");
        System.out.println(this.agentsAppState.getAgentIds());
        for (String id : this.agentsAppState.getAgentIds()) {
            Agent a = this.agentsAppState.getAgent(id);
            if (a.getAutomaton() != null) {
                a.getAutomaton().addListener((AutomatonListener)this);
            }
            a.addListener((AgentListener)this);
            Logger logger = Logger.getLogger(id);
            this.loggers.put(id, logger);
            logger.addHandler(tableHandler);
            if (fh == null) continue;
            logger.addHandler(fh);
        }
        System.out.println("***************************\n\n\n");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoggingViewerAppState.this.frame = new JFrame("PHAT Log viewer");
                LogViewerPanel newContentPane = new LogViewerPanel(LoggingViewerAppState.this.tableModel);
                newContentPane.setOpaque(true);
                LoggingViewerAppState.this.frame.setContentPane(newContentPane);
                LoggingViewerAppState.this.frame.pack();
            }
        });
    }

    public void update(float tpf) {
        super.update(tpf);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    public boolean isShown() {
        return this.frame.isVisible();
    }

    public void hide() {
        this.frame.setVisible(false);
    }

    public void cleanup() {
        super.cleanup();
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
    }

    public void stateChanged(Automaton automaton, Automaton.STATE state) {
        this.log(automaton, state.name());
        if (state == Automaton.STATE.STARTED) {
            automaton.addListener((AutomatonListener)this);
        }
    }

    private void log(Automaton automaton, String state) {
        String message = automaton.getMetadata("SOCIAALML_DESCRIPTION");
        String taskID = automaton.getMetadata("SOCIAALML_ENTITY_ID");
        String taskType = automaton.getMetadata("SOCIAALML_ENTITY_TYPE");
        if (taskID == null || taskID.equals("")) {
            taskID = automaton.getName();
            taskType = automaton.getClass().getSimpleName();
            message = "";
        }
        String secs = "" + this.simStartTime.spentTimeTo(this.simTime);
        String time = this.getTwoDigits(this.simTime.getHourOfDay()) + ":" + this.getTwoDigits(this.simTime.getMinute()) + ":" + this.getTwoDigits(this.simTime.getSecond()) + "-" + this.getTwoDigits(this.simTime.getMonth()) + "/" + this.getTwoDigits(this.simTime.getDayOfMonth()) + "/" + this.simTime.getYear();
        Logger logger = this.loggers.get(automaton.getAgent().getId());
        Object[] params = new Object[]{secs, time, state, taskID, taskType, automaton};
        logger.log(Level.INFO, message, params);
    }

    private String getTwoDigits(int number) {
        if (number < 10) {
            return "0" + number;
        }
        return "" + number;
    }

    public void agentChanged(Agent agent) {
        if (agent.getAutomaton() != null) {
            agent.getAutomaton().addListener((AutomatonListener)this);
        }
    }
}

