/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.logging;

import phat.PHATInitializer;
import phat.PHATInterface;
import phat.agents.Agent;
import phat.agents.HumanAgent;
import phat.agents.automaton.Automaton;
import phat.agents.automaton.AutomatonIcon;
import phat.agents.automaton.AutomatonListener;
import phat.agents.automaton.DoNothing;
import phat.agents.automaton.DrinkAutomaton;
import phat.agents.automaton.FSM;
import phat.agents.automaton.FallAutomaton;
import phat.agents.automaton.GoIntoBedAutomaton;
import phat.agents.automaton.MoveToSpace;
import phat.agents.automaton.SayAutomaton;
import phat.agents.automaton.SitDownAutomaton;
import phat.agents.automaton.StandUpAutomaton;
import phat.agents.automaton.UseObjectAutomaton;
import phat.agents.automaton.conditions.AutomatonCondition;
import phat.agents.automaton.conditions.TimerFinishedCondition;
import phat.agents.automaton.uses.UseDoorbellAutomaton;
import phat.body.BodiesAppState;
import phat.body.commands.SetBodyHeightCommand;
import phat.body.commands.SetPCListenerToBodyCommand;
import phat.body.commands.SetStoopedBodyCommand;
import phat.body.commands.TremblingHandCommand;
import phat.body.commands.TremblingHeadCommand;
import phat.commands.PHATCommand;
import phat.config.AgentConfigurator;
import phat.config.BodyConfigurator;
import phat.config.DeviceConfigurator;
import phat.config.HouseConfigurator;
import phat.config.ServerConfigurator;
import phat.config.WorldConfigurator;
import phat.structures.houses.HouseFactory;
import phat.world.WorldAppState;

public class TestLoggingViewer
implements PHATInitializer {
    public static void main(String[] args) {
        TestLoggingViewer sim = new TestLoggingViewer();
        PHATInterface phat = new PHATInterface((PHATInitializer)sim);
        phat.start();
    }

    public void initWorld(WorldConfigurator worldConfig) {
        worldConfig.setTime(2014, 2, 3, 14, 0, 0);
        worldConfig.setTimeVisible(true);
        worldConfig.setLandType(WorldAppState.LandType.Grass);
    }

    public void initHouse(HouseConfigurator houseConfig) {
        houseConfig.addHouseType("House1", HouseFactory.HouseType.House3room2bath);
    }

    public void initBodies(BodyConfigurator bodyConfig) {
        bodyConfig.createBody(BodiesAppState.BodyType.ElderLP, "Relative");
        bodyConfig.setInSpace("Relative", "House1", "BedRoom1");
        bodyConfig.runCommand((PHATCommand)new TremblingHeadCommand("Relative", Boolean.valueOf(true)));
        bodyConfig.runCommand((PHATCommand)new SetStoopedBodyCommand("Relative", Boolean.valueOf(true)));
        bodyConfig.runCommand((PHATCommand)new TremblingHandCommand("Relative", Boolean.valueOf(true), Boolean.valueOf(true)));
        bodyConfig.runCommand((PHATCommand)new SetPCListenerToBodyCommand("Relative"));
        bodyConfig.runCommand((PHATCommand)new SetBodyHeightCommand("Relative", 1.7f));
    }

    public void initDevices(DeviceConfigurator deviceConfig) {
    }

    public void initServer(ServerConfigurator deviceConfig) {
    }

    public void initAgents(AgentConfigurator agentsConfig) {
        HumanAgent relative = new HumanAgent("Relative");
        MoveToSpace moveToBathroom1 = new MoveToSpace((Agent)relative, "GoToBathRoom1", "BathRoom1");
        UseObjectAutomaton useShower = new UseObjectAutomaton((Agent)relative, "Shower1");
        useShower.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 20));
        UseObjectAutomaton useWC1 = new UseObjectAutomaton((Agent)relative, "WC1");
        useWC1.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 10));
        UseObjectAutomaton useBasin1 = new UseObjectAutomaton((Agent)relative, "Basin1");
        useBasin1.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 10));
        MoveToSpace moveToBedroom1 = new MoveToSpace((Agent)relative, "GoToBedRoom1", "BedRoom1");
        GoIntoBedAutomaton goIntoBed = new GoIntoBedAutomaton((Agent)relative, "Bed1");
        StandUpAutomaton standUp1 = new StandUpAutomaton((Agent)relative, "StandUpFromBed");
        StandUpAutomaton standUp2 = new StandUpAutomaton((Agent)relative, "StandUpFromBed");
        DoNothing sleep = new DoNothing((Agent)relative, "Sleep");
        sleep.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 3));
        MoveToSpace moveToGettingDressedArea1 = new MoveToSpace((Agent)relative, "GoToGettingDressedArea1", "GettingDressedArea1");
        MoveToSpace moveToHaveBreakfast = new MoveToSpace((Agent)relative, "GoToHaveBreakfast", "Kitchen");
        SitDownAutomaton sitDownInKitchen = new SitDownAutomaton((Agent)relative, "Chair1");
        Automaton haveBreakfast = new DrinkAutomaton((Agent)relative).setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 20));
        UseObjectAutomaton useSink = new UseObjectAutomaton((Agent)relative, "Sink");
        useSink.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 30));
        DoNothing fin = new DoNothing((Agent)relative, "Fin");
        fin.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 30));
        UseDoorbellAutomaton useDoorbell = new UseDoorbellAutomaton((Agent)relative, "Doorbell1");
        FallAutomaton fall = new FallAutomaton((Agent)relative, "TripOver");
        fall.setFinishCondition((AutomatonCondition)new TimerFinishedCondition(0, 0, 5));
        SayAutomaton goodMorning = new SayAutomaton((Agent)relative, "SayGoodMorning", "Good Morning, Jorge!", 0.1f);
        StandUpAutomaton standUp3 = new StandUpAutomaton((Agent)relative, "StandUp");
        FSM fsm = new FSM((Agent)relative);
        fsm.registerStartState((Automaton)goIntoBed);
        fsm.registerTransition((Automaton)goIntoBed, (Automaton)sleep);
        fsm.registerTransition((Automaton)sleep, (Automaton)standUp1);
        fsm.registerTransition((Automaton)standUp1, (Automaton)goodMorning);
        fsm.registerTransition((Automaton)goodMorning, (Automaton)moveToBathroom1);
        fsm.registerTransition((Automaton)moveToBathroom1, (Automaton)fall);
        fsm.registerTransition((Automaton)fall, (Automaton)standUp3);
        fsm.registerTransition((Automaton)standUp3, (Automaton)useShower);
        fsm.registerTransition((Automaton)useShower, (Automaton)useWC1);
        fsm.registerTransition((Automaton)useWC1, (Automaton)useBasin1);
        fsm.registerTransition((Automaton)useBasin1, (Automaton)moveToHaveBreakfast);
        fsm.registerTransition((Automaton)moveToHaveBreakfast, (Automaton)sitDownInKitchen);
        fsm.registerTransition((Automaton)sitDownInKitchen, haveBreakfast);
        fsm.registerTransition(haveBreakfast, (Automaton)standUp2);
        fsm.registerTransition((Automaton)standUp2, (Automaton)useSink);
        fsm.registerTransition((Automaton)useSink, (Automaton)fin);
        fsm.registerFinalState((Automaton)fin);
        fsm.addListener((AutomatonListener)new AutomatonIcon());
        relative.setAutomaton((Automaton)fsm);
        agentsConfig.add((Agent)relative);
    }

    public String getTittle() {
        return "PHAT-" + this.getClass().getSimpleName();
    }
}

