/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.logging.control;

import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableRowSorter;
import phat.agents.AgentsAppState;
import phat.agents.automaton.Automaton;
import phat.gui.logging.LogRecordTableModel;
import phat.gui.logging.control.CheckBoxMenuItemRowFilter;

public class LogViewerControlPanel
extends JPanel {
    LogRecordTableModel tableModel;
    JTable table;
    AgentsAppState agentsAppState;
    TableRowSorter<LogRecordTableModel> sorter;
    ItemListener updateTable = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            System.out.println("Selected: " + ((JCheckBoxMenuItem)e.getItem()).getText());
            LogViewerControlPanel.this.sorter.allRowsChanged();
        }
    };

    public LogViewerControlPanel(JTable table) {
        this.tableModel = (LogRecordTableModel)table.getModel();
        this.table = table;
        this.agentsAppState = this.tableModel.getAgentsAppState();
        this.setBorder(new TitledBorder("Filtering Controls"));
        this.createStateChecks();
    }

    private void createStateChecks() {
        CheckBoxMenuItemRowFilter filter = new CheckBoxMenuItemRowFilter();
        ArrayList<String> agentsOptions = new ArrayList<String>();
        for (String id : this.agentsAppState.getAgentIds()) {
            agentsOptions.add(id);
        }
        this.createGroupFiltering("Agents", filter, 2, agentsOptions);
        ArrayList<String> stateOptions = new ArrayList<String>();
        for (Automaton.STATE state : Automaton.STATE.values()) {
            stateOptions.add(state.name());
        }
        this.createGroupFiltering("States", filter, 3, stateOptions);
        this.sorter = new TableRowSorter<LogRecordTableModel>(this.tableModel);
        this.sorter.setRowFilter(filter);
        this.table.setRowSorter(this.sorter);
    }

    private void createGroupFiltering(String name, CheckBoxMenuItemRowFilter filter, int index, List<String> options) {
        final JPopupMenu menu = new JPopupMenu();
        ArrayList<JCheckBoxMenuItem> cBoxes = new ArrayList<JCheckBoxMenuItem>();
        filter.setCheckBoxItemList(index, cBoxes);
        for (String op : options) {
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(op);
            cbmi.addItemListener(this.updateTable);
            menu.add(cbmi);
            cBoxes.add(cbmi);
        }
        final JButton button = new JButton();
        button.setAction(new AbstractAction(name){

            @Override
            public void actionPerformed(ActionEvent e) {
                menu.show(button, 0, button.getHeight());
            }
        });
        this.add(button);
    }
}

