/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.screenshot;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.event.MouseButtonEvent;
import com.jme3.material.Material;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import phat.gui.GUIMainMenuAppState;
import phat.util.PHATScreenshotAppState;
import tonegod.gui.controls.text.Label;
import tonegod.gui.controls.text.TextField;
import tonegod.gui.controls.windows.Window;
import tonegod.gui.core.Element;
import tonegod.gui.core.Screen;
import tonegod.gui.effects.Effect;

public class GUIScreenShotAppState
extends AbstractAppState {
    Screen screen;
    Window window;
    TextField fileNameTextField;
    TextField filePathTextField;
    Label imagePanel;
    SimpleApplication app;
    PHATScreenshotAppState phatScreenshotAppState;

    public GUIScreenShotAppState(Screen screen) {
        this.screen = screen;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = (SimpleApplication)app;
        this.phatScreenshotAppState = (PHATScreenshotAppState)this.app.getStateManager().getState(PHATScreenshotAppState.class);
        if (this.phatScreenshotAppState == null) {
            this.phatScreenshotAppState = new PHATScreenshotAppState();
            this.app.getStateManager().attach((AppState)this.phatScreenshotAppState);
        }
        this.phatScreenshotAppState.takeScreenshot();
    }

    public void update(float tpf) {
        if (this.phatScreenshotAppState.isImageReady() && this.imagePanel == null) {
            this.screen.parseLayout("Interface/ScreenshotWindow.gui.xml", (AbstractAppState)this);
            this.window = (Window)this.screen.getElementById("ScreenshotWindow");
            this.fileNameTextField = (TextField)this.screen.getElementById("FileNameTextField");
            this.fileNameTextField.setText(this.phatScreenshotAppState.getFileName());
            this.filePathTextField = (TextField)this.screen.getElementById("FilePathTextField");
            System.out.println("FilePath = " + this.phatScreenshotAppState.getFilePath());
            this.filePathTextField.setText(this.phatScreenshotAppState.getFilePath());
            this.imagePanel = (Label)this.screen.getElementById("ScreenshotImage");
            this.window.setPosition((this.screen.getWidth() - this.window.getWidth()) / 2.0f, (this.screen.getHeight() - this.window.getHeight()) / 2.0f);
            Image image = this.phatScreenshotAppState.getImage();
            Texture2D texture = new Texture2D(image);
            texture.setMagFilter(Texture.MagFilter.Nearest);
            Material mat = new Material(this.app.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
            mat.setTexture("ColorMap", (Texture)texture);
            float factor = (float)this.phatScreenshotAppState.getImage().getWidth() / (float)this.phatScreenshotAppState.getImage().getHeight();
            System.out.println("iWidth" + this.phatScreenshotAppState.getImage().getWidth());
            System.out.println("iHeight" + this.phatScreenshotAppState.getImage().getHeight());
            System.out.println("factor = " + factor);
            System.out.println("width = " + this.imagePanel.getDimensions().x);
            System.out.println("height = " + this.imagePanel.getDimensions().y);
            this.imagePanel.setDimensions(this.imagePanel.getDimensions().x * factor, this.imagePanel.getDimensions().y);
            this.imagePanel.setMaterial(mat);
            this.imagePanel.setPosition((this.window.getWidth() - this.imagePanel.getWidth()) / 2.0f, this.imagePanel.getPosition().y);
        }
    }

    public void saveScreenshot(MouseButtonEvent evt, boolean isToggle) {
        this.phatScreenshotAppState.setFileName(this.fileNameTextField.getText());
        this.phatScreenshotAppState.setFilePath(this.filePathTextField.getText());
        this.phatScreenshotAppState.saveScreenshot();
        this.app.getStateManager().detach((AppState)this);
    }

    public void cleanup() {
        super.cleanup();
        Effect hide = new Effect(Effect.EffectType.FadeOut, Effect.EffectEvent.Hide, 0.25f);
        hide.setDestroyOnHide(true);
        this.screen.removeElement((Element)this.window);
        this.app.getStateManager().attach((AppState)new GUIMainMenuAppState(this.screen));
    }
}

