/*
 * Decompiled with CFR 0.152.
 */
package phat.gui.time;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import phat.gui.GUIMainMenuAppState;
import phat.world.WorldAppState;
import tonegod.gui.controls.text.Label;
import tonegod.gui.controls.windows.Window;
import tonegod.gui.core.Element;
import tonegod.gui.core.Screen;
import tonegod.gui.effects.Effect;

public class TimeAppState
extends AbstractAppState {
    Screen screen;
    Window window;
    Label timeLabel;
    SimpleApplication app;
    WorldAppState worldAppState;

    public TimeAppState(Screen screen) {
        this.screen = screen;
    }

    public void initialize(AppStateManager stateManager, Application app) {
        super.initialize(stateManager, app);
        this.app = (SimpleApplication)app;
        this.worldAppState = (WorldAppState)this.app.getStateManager().getState(WorldAppState.class);
        this.screen.parseLayout("Interface/TimeDate.gui.xml", (AbstractAppState)this.app.getStateManager().getState(GUIMainMenuAppState.class));
        this.window = (Window)this.screen.getElementById("TimeWindow");
        this.timeLabel = (Label)this.screen.getElementById("TimeLabel");
        this.window.setPosition(this.screen.getWidth() - this.window.getWidth(), 0.0f);
    }

    public void update(float tpf) {
        if (this.worldAppState != null) {
            this.timeLabel.setText(this.worldAppState.getCalendar().toString());
        }
    }

    public void cleanup() {
        super.cleanup();
        Effect hide = new Effect(Effect.EffectType.FadeOut, Effect.EffectEvent.Hide, 0.25f);
        hide.setDestroyOnHide(true);
        this.screen.removeElement((Element)this.window);
        for (Element e : this.screen.getElements()) {
            System.out.println("Element = " + e.getName());
        }
    }
}

