/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ExceptionExcludedOffsetFilter;
import proguard.optimize.peephole.BranchTargetFinder;

public class CodeSubroutineInliner
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private final BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
    private final CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer(true, true);
    private ExceptionInfoVisitor subroutineExceptionInliner = this;
    private int clipStart = 0;
    private int clipEnd = Integer.MAX_VALUE;

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while inlining subroutines:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int instructionLength;
        this.branchTargetFinder.visitCodeAttribute(clazz, method, codeAttribute);
        if (!this.branchTargetFinder.containsSubroutines()) {
            return;
        }
        this.codeAttributeComposer.reset();
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        for (int offset = 0; offset < codeAttribute.u4codeLength; offset += instructionLength) {
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            instructionLength = instruction.length(offset);
            if (this.branchTargetFinder.isSubroutine(offset) && this.branchTargetFinder.isSubroutineReturning(offset)) {
                this.codeAttributeComposer.appendLabel(offset);
                continue;
            }
            instruction.accept(clazz, method, codeAttribute, offset, this);
        }
        codeAttribute.exceptionsAccept(clazz, method, this.subroutineExceptionInliner);
        this.codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        this.codeAttributeComposer.endCodeFragment();
        this.codeAttributeComposer.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void inlineSubroutine(Clazz clazz, Method method, CodeAttribute codeAttribute, int subroutineInvocationOffset, int subroutineStart) {
        int subroutineEnd = this.branchTargetFinder.subroutineEnd(subroutineStart);
        ExceptionInfoVisitor oldSubroutineExceptionInliner = this.subroutineExceptionInliner;
        int oldClipStart = this.clipStart;
        int oldClipEnd = this.clipEnd;
        this.subroutineExceptionInliner = new ExceptionExcludedOffsetFilter(subroutineInvocationOffset, this.subroutineExceptionInliner);
        this.clipStart = subroutineStart;
        this.clipEnd = subroutineEnd;
        this.codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, subroutineStart, subroutineEnd, this);
        this.codeAttributeComposer.appendLabel(subroutineEnd);
        codeAttribute.exceptionsAccept(clazz, method, subroutineStart, subroutineEnd, this.subroutineExceptionInliner);
        this.subroutineExceptionInliner = oldSubroutineExceptionInliner;
        this.clipStart = oldClipStart;
        this.clipEnd = oldClipEnd;
        this.codeAttributeComposer.endCodeFragment();
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.codeAttributeComposer.appendInstruction(offset, instruction);
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        if (opcode == -87) {
            if (this.branchTargetFinder.subroutineEnd(offset) == offset + variableInstruction.length(offset)) {
                this.codeAttributeComposer.appendLabel(offset);
            } else {
                BranchInstruction replacementInstruction = new BranchInstruction(-89, this.branchTargetFinder.subroutineEnd(offset) - offset);
                this.codeAttributeComposer.appendInstruction(offset, replacementInstruction);
            }
        } else if (this.branchTargetFinder.isSubroutineStart(offset)) {
            this.codeAttributeComposer.appendLabel(offset);
        } else {
            this.codeAttributeComposer.appendInstruction(offset, variableInstruction);
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        if (opcode == -88 || opcode == -55) {
            int branchOffset = branchInstruction.branchOffset;
            int branchTarget = offset + branchOffset;
            if (this.branchTargetFinder.isSubroutineReturning(branchTarget)) {
                this.codeAttributeComposer.appendLabel(offset);
                this.inlineSubroutine(clazz, method, codeAttribute, offset, branchTarget);
            } else {
                BranchInstruction replacementInstruction = new BranchInstruction(-89, branchOffset);
                this.codeAttributeComposer.appendInstruction(offset, replacementInstruction);
            }
        } else {
            this.codeAttributeComposer.appendInstruction(offset, branchInstruction);
        }
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int startPC = Math.max(exceptionInfo.u2startPC, this.clipStart);
        int endPC = Math.min(exceptionInfo.u2endPC, this.clipEnd);
        int handlerPC = exceptionInfo.u2handlerPC;
        int catchType = exceptionInfo.u2catchType;
        for (int offset = startPC; offset < endPC; ++offset) {
            if (!this.branchTargetFinder.isSubroutineInvocation(offset)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            int instructionLength = instruction.length(offset);
            if (exceptionInfo.isApplicable(offset + ((BranchInstruction)instruction).branchOffset)) continue;
            this.codeAttributeComposer.appendException(new ExceptionInfo(startPC, offset, handlerPC, catchType));
            startPC = offset + instructionLength;
        }
        this.codeAttributeComposer.appendException(new ExceptionInfo(startPC, endPC, handlerPC, catchType));
    }
}

