/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class MethodDescriptorShrinker
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraMemberVisitor;

    public MethodDescriptorShrinker() {
        this(null);
    }

    public MethodDescriptorShrinker(MemberVisitor extraMemberVisitor) {
        this.extraMemberVisitor = extraMemberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String newDescriptor;
        String descriptor = programMethod.getDescriptor(programClass);
        if (!descriptor.equals(newDescriptor = this.shrinkDescriptor(programMethod, descriptor))) {
            String name;
            programMethod.attributesAccept(programClass, this);
            String newName = name = programMethod.getName(programClass);
            if (!name.equals("<init>")) {
                newName = newName + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!newName.equals(name)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
            programMethod.referencedClasses = this.shrinkReferencedClasses(programMethod, descriptor, programMethod.referencedClasses);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            if (this.extraMemberVisitor != null) {
                this.extraMemberVisitor.visitProgramMethod(programClass, programMethod);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String signature = clazz.getString(signatureAttribute.u2signatureIndex);
        String newSignature = this.shrinkDescriptor(method, signature);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        signatureAttribute.referencedClasses = this.shrinkReferencedClasses(method, signature, signatureAttribute.referencedClasses);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int[] annotationsCounts = parameterAnnotationsAttribute.u2parameterAnnotationsCount;
        Annotation[][] annotations = parameterAnnotationsAttribute.parameterAnnotations;
        int parameterIndex = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
        int annotationIndex = 0;
        int newAnnotationIndex = 0;
        String descriptor = method.getDescriptor(clazz);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        while (internalTypeEnumeration.hasMoreTypes()) {
            String type = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                annotationsCounts[newAnnotationIndex] = annotationsCounts[annotationIndex];
                annotations[newAnnotationIndex++] = annotations[annotationIndex];
            }
            ++annotationIndex;
            parameterIndex += ClassUtil.isInternalCategory2Type(type) ? 2 : 1;
        }
        parameterAnnotationsAttribute.u2parametersCount = newAnnotationIndex;
        while (newAnnotationIndex < annotationIndex) {
            annotationsCounts[newAnnotationIndex] = 0;
            annotations[newAnnotationIndex++] = null;
        }
    }

    private String shrinkDescriptor(Method method, String descriptor) {
        int parameterIndex = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
        StringBuffer newDescriptorBuffer = new StringBuffer();
        newDescriptorBuffer.append(internalTypeEnumeration.formalTypeParameters());
        newDescriptorBuffer.append('(');
        while (internalTypeEnumeration.hasMoreTypes()) {
            String type = internalTypeEnumeration.nextType();
            if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                newDescriptorBuffer.append(type);
            }
            parameterIndex += ClassUtil.isInternalCategory2Type(type) ? 2 : 1;
        }
        newDescriptorBuffer.append(')');
        newDescriptorBuffer.append(internalTypeEnumeration.returnType());
        return newDescriptorBuffer.toString();
    }

    private Clazz[] shrinkReferencedClasses(Method method, String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            int counter;
            int parameterIndex = (method.getAccessFlags() & 8) != 0 ? 0 : 1;
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
            String type = internalTypeEnumeration.formalTypeParameters();
            int count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                type = internalTypeEnumeration.nextType();
                count = new DescriptorClassEnumeration(type).classCount();
                if (ParameterUsageMarker.isParameterUsed(method, parameterIndex)) {
                    for (counter = 0; counter < count; ++counter) {
                        referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
                    }
                } else {
                    referencedClassIndex += count;
                }
                parameterIndex += ClassUtil.isInternalCategory2Type(type) ? 2 : 1;
            }
            type = internalTypeEnumeration.returnType();
            count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                referencedClasses[newReferencedClassIndex++] = referencedClasses[referencedClassIndex++];
            }
            while (newReferencedClassIndex < referencedClassIndex) {
                referencedClasses[newReferencedClassIndex++] = null;
            }
        }
        return referencedClasses;
    }
}

