/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.KeepSpecification;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationWriter {
    private static final String[] KEEP_OPTIONS = new String[]{"-keep", "-keepclassmembers", "-keepclasseswithmembers"};
    private final PrintWriter writer;
    private File baseDir;

    public ConfigurationWriter(File configurationFile) throws IOException {
        this(new PrintWriter(new FileWriter(configurationFile)));
        this.baseDir = configurationFile.getParentFile();
    }

    public ConfigurationWriter(OutputStream outputStream) throws IOException {
        this(new PrintWriter(outputStream));
    }

    public ConfigurationWriter(PrintWriter writer) throws IOException {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Configuration configuration) throws IOException {
        this.writeJarOptions("-injars", "-outjars", configuration.programJars);
        this.writer.println();
        this.writeJarOptions("-libraryjars", "-libraryjars", configuration.libraryJars);
        this.writer.println();
        this.writeOption("-dontskipnonpubliclibraryclasses", !configuration.skipNonPublicLibraryClasses);
        this.writeOption("-dontskipnonpubliclibraryclassmembers", !configuration.skipNonPublicLibraryClassMembers);
        this.writeOption("-target", ClassUtil.externalClassVersion(configuration.targetClassVersion));
        this.writeOption("-forceprocessing", configuration.lastModified == Long.MAX_VALUE);
        this.writeOption("-dontshrink", !configuration.shrink);
        this.writeOption("-printusage", configuration.printUsage);
        this.writeOption("-dontoptimize", !configuration.optimize);
        this.writeOption("-optimizationpasses", configuration.optimizationPasses);
        this.writeOption("-allowaccessmodification", configuration.allowAccessModification);
        this.writeOption("-dontobfuscate", !configuration.obfuscate);
        this.writeOption("-printmapping", configuration.printMapping);
        this.writeOption("-applymapping", configuration.applyMapping);
        this.writeOption("-obfuscationdictionary", configuration.obfuscationDictionary);
        this.writeOption("-overloadaggressively", configuration.overloadAggressively);
        this.writeOption("-useuniqueclassmembernames", configuration.useUniqueClassMemberNames);
        this.writeOption("-dontusemixedcaseclassnames", !configuration.useMixedCaseClassNames);
        this.writeOption("-flattenpackagehierarchy", configuration.flattenPackageHierarchy == null ? null : ClassUtil.externalClassName(configuration.flattenPackageHierarchy));
        this.writeOption("-repackageclasses", configuration.repackageClasses == null ? null : ClassUtil.externalClassName(configuration.repackageClasses));
        this.writeOption("-keepattributes", ListUtil.commaSeparatedString(configuration.keepAttributes));
        this.writeOption("-renamesourcefileattribute", configuration.newSourceFileAttribute);
        this.writeOption("-adaptresourcefilenames", ListUtil.commaSeparatedString(configuration.adaptResourceFileNames));
        this.writeOption("-adaptresourcefilecontents", ListUtil.commaSeparatedString(configuration.adaptResourceFileContents));
        this.writeOption("-dontpreverify", !configuration.preverify);
        this.writeOption("-microedition", configuration.microEdition);
        this.writeOption("-verbose", configuration.verbose);
        this.writeOption("-dontnote", !configuration.note);
        this.writeOption("-dontwarn", !configuration.warn);
        this.writeOption("-ignorewarnings", configuration.ignoreWarnings);
        this.writeOption("-printconfiguration", configuration.printConfiguration);
        this.writeOption("-dump", configuration.dump);
        this.writeOption("-printseeds", configuration.printSeeds);
        this.writer.println();
        this.writeOptions("-whyareyoukeeping", configuration.whyAreYouKeeping);
        this.writeOptions(KEEP_OPTIONS, configuration.keep);
        this.writeOptions("-assumenosideeffects", configuration.assumeNoSideEffects);
        if (this.writer.checkError()) {
            throw new IOException("Can't write configuration");
        }
    }

    private void writeJarOptions(String inputEntryOptionName, String outputEntryOptionName, ClassPath classPath) {
        if (classPath != null) {
            for (int index = 0; index < classPath.size(); ++index) {
                ClassPathEntry entry = classPath.get(index);
                String optionName = entry.isOutput() ? outputEntryOptionName : inputEntryOptionName;
                this.writer.print(optionName);
                this.writer.print(' ');
                this.writer.print(this.relativeFileName(entry.getFile()));
                boolean filtered = false;
                filtered = this.writeFilter(filtered, entry.getZipFilter());
                filtered = this.writeFilter(filtered, entry.getEarFilter());
                filtered = this.writeFilter(filtered, entry.getWarFilter());
                filtered = this.writeFilter(filtered, entry.getJarFilter());
                filtered = this.writeFilter(filtered, entry.getFilter());
                if (filtered) {
                    this.writer.print(")");
                }
                this.writer.println();
            }
        }
    }

    private boolean writeFilter(boolean filtered, String filter) {
        if (filtered) {
            this.writer.print(";");
        }
        if (filter != null) {
            if (!filtered) {
                this.writer.print("(");
            }
            this.writer.print(this.quotedString(filter));
            filtered = true;
        }
        return filtered;
    }

    private void writeOption(String optionName, boolean flag) {
        if (flag) {
            this.writer.println(optionName);
        }
    }

    private void writeOption(String optionName, int argument) {
        if (argument != 1) {
            this.writer.print(optionName);
            this.writer.print(' ');
            this.writer.println(argument);
        }
    }

    private void writeOption(String optionName, String arguments) {
        if (arguments != null) {
            this.writer.print(optionName);
            this.writer.print(' ');
            this.writer.println(this.quotedString(arguments));
        }
    }

    private void writeOption(String optionName, File file) {
        if (file != null) {
            if (file.getPath().length() > 0) {
                this.writer.print(optionName);
                this.writer.print(' ');
                this.writer.println(this.relativeFileName(file));
            } else {
                this.writer.println(optionName);
            }
        }
    }

    private void writeOptions(String[] optionNames, List keepSpecifications) {
        if (keepSpecifications != null) {
            for (int index = 0; index < keepSpecifications.size(); ++index) {
                this.writeOption(optionNames, (KeepSpecification)keepSpecifications.get(index));
            }
        }
    }

    private void writeOption(String[] optionNames, KeepSpecification keepSpecification) {
        String optionName = optionNames[keepSpecification.markConditionally ? 2 : (keepSpecification.markClasses ? 0 : 1)];
        if (keepSpecification.allowShrinking) {
            optionName = optionName + ",allowshrinking";
        }
        if (keepSpecification.allowOptimization) {
            optionName = optionName + ",allowoptimization";
        }
        if (keepSpecification.allowObfuscation) {
            optionName = optionName + ",allowobfuscation";
        }
        this.writeOption(optionName, (ClassSpecification)keepSpecification);
    }

    private void writeOptions(String optionName, List classSpecifications) {
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                this.writeOption(optionName, (ClassSpecification)classSpecifications.get(index));
            }
        }
    }

    private void writeOption(String optionName, ClassSpecification classSpecification) {
        this.writer.println();
        this.writeComments(classSpecification.comments);
        this.writer.print(optionName);
        this.writer.print(' ');
        if (classSpecification.annotationType != null) {
            this.writer.print("@");
            this.writer.print(ClassUtil.externalType(classSpecification.annotationType));
            this.writer.print(' ');
        }
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredUnsetAccessFlags, "!"));
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredSetAccessFlags));
        if (((classSpecification.requiredSetAccessFlags | classSpecification.requiredUnsetAccessFlags) & 0x200) == 0) {
            this.writer.print("class");
        }
        this.writer.print(' ');
        this.writer.print(classSpecification.className != null ? ClassUtil.externalClassName(classSpecification.className) : "*");
        if (classSpecification.extendsAnnotationType != null || classSpecification.extendsClassName != null) {
            this.writer.print(' ');
            this.writer.print("extends");
            this.writer.print(' ');
            if (classSpecification.extendsAnnotationType != null) {
                this.writer.print("@");
                this.writer.print(ClassUtil.externalType(classSpecification.extendsAnnotationType));
                this.writer.print(' ');
            }
            this.writer.print(classSpecification.extendsClassName != null ? ClassUtil.externalClassName(classSpecification.extendsClassName) : "*");
        }
        if (classSpecification.fieldSpecifications != null || classSpecification.methodSpecifications != null) {
            this.writer.print(' ');
            this.writer.println("{");
            this.writeFieldSpecification(classSpecification.fieldSpecifications);
            this.writeMethodSpecification(classSpecification.methodSpecifications);
            this.writer.println("}");
        } else {
            this.writer.println();
        }
    }

    private void writeComments(String comments) {
        if (comments != null) {
            int index = 0;
            while (index < comments.length()) {
                int breakIndex = comments.indexOf(10, index);
                if (breakIndex < 0) {
                    breakIndex = comments.length();
                }
                this.writer.print('#');
                if (comments.charAt(index) != ' ') {
                    this.writer.print(' ');
                }
                this.writer.println(comments.substring(index, breakIndex));
                index = breakIndex + 1;
            }
        }
    }

    private void writeFieldSpecification(List memberSpecifications) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                this.writer.print("    ");
                if (memberSpecification.annotationType != null) {
                    this.writer.print("@");
                    this.writer.println(ClassUtil.externalType(memberSpecification.annotationType));
                    this.writer.print("    ");
                }
                this.writer.print(ClassUtil.externalFieldAccessFlags(memberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalFieldAccessFlags(memberSpecification.requiredSetAccessFlags));
                String name = memberSpecification.name;
                String descriptor = memberSpecification.descriptor;
                this.writer.print(descriptor == null ? (name == null ? "<fields>" : "*** " + name) : ClassUtil.externalFullFieldDescription(0, name == null ? "*" : name, descriptor));
                this.writer.println(";");
            }
        }
    }

    private void writeMethodSpecification(List memberSpecifications) {
        if (memberSpecifications != null) {
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                this.writer.print("    ");
                if (memberSpecification.annotationType != null) {
                    this.writer.print("@");
                    this.writer.println(ClassUtil.externalType(memberSpecification.annotationType));
                    this.writer.print("    ");
                }
                this.writer.print(ClassUtil.externalMethodAccessFlags(memberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalMethodAccessFlags(memberSpecification.requiredSetAccessFlags));
                String name = memberSpecification.name;
                String descriptor = memberSpecification.descriptor;
                this.writer.print(descriptor == null ? (name == null ? "<methods>" : "*** " + name + "(" + "..." + ")") : ClassUtil.externalFullMethodDescription("<init>", 0, name == null ? "*" : name, descriptor));
                this.writer.println(";");
            }
        }
    }

    private String relativeFileName(File file) {
        String baseDirName;
        String fileName = file.getAbsolutePath();
        if (this.baseDir != null && fileName.startsWith(baseDirName = this.baseDir.getAbsolutePath() + File.separator)) {
            fileName = fileName.substring(baseDirName.length());
        }
        return this.quotedString(fileName);
    }

    private String quotedString(String string) {
        return string.length() == 0 || string.indexOf(32) >= 0 || string.indexOf(64) >= 0 || string.indexOf(123) >= 0 || string.indexOf(125) >= 0 || string.indexOf(40) >= 0 || string.indexOf(41) >= 0 || string.indexOf(58) >= 0 || string.indexOf(59) >= 0 ? "'" + string + "'" : string;
    }

    public static void main(String[] args) {
        try {
            ConfigurationWriter writer = new ConfigurationWriter(new File(args[0]));
            writer.write(new Configuration());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

