/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.io.ClassFilter;
import proguard.io.ClassRewriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRenamer;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.FilteredDataEntryReader;
import proguard.util.FileNameParser;
import proguard.util.ListParser;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool) throws IOException {
        ClassPath programJars = this.configuration.programJars;
        ClassPathEntry firstEntry = programJars.get(0);
        if (firstEntry.isOutput()) {
            throw new IOException("The output jar [" + firstEntry.getName() + "] must be specified after an input jar, or it will be empty.");
        }
        for (int index = 0; index < programJars.size() - 1; ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) continue;
            if (entry.getFilter() == null && entry.getJarFilter() == null && entry.getWarFilter() == null && entry.getEarFilter() == null && entry.getZipFilter() == null && programJars.get(index + 1).isOutput()) {
                throw new IOException("The output jar [" + entry.getName() + "] must have a filter, or all subsequent jars will be empty.");
            }
            for (int inIndex = 0; inIndex < programJars.size(); ++inIndex) {
                ClassPathEntry otherEntry = programJars.get(inIndex);
                if (otherEntry.isOutput() || !entry.getFile().equals(otherEntry.getFile())) continue;
                throw new IOException("The output jar [" + entry.getName() + "] must be different from all input jars.");
            }
        }
        int firstInputIndex = 0;
        int lastInputIndex = 0;
        for (int index = 0; index < programJars.size(); ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) {
                lastInputIndex = index;
                continue;
            }
            int nextIndex = index + 1;
            if (nextIndex != programJars.size() && programJars.get(nextIndex).isOutput()) continue;
            this.writeOutput(programClassPool, programJars, firstInputIndex, lastInputIndex + 1, nextIndex);
            firstInputIndex = nextIndex;
        }
    }

    private void writeOutput(ClassPool programClassPool, ClassPath classPath, int fromInputIndex, int fromOutputIndex, int toOutputIndex) throws IOException {
        try {
            DataEntryReader adaptedResourceRewriter;
            DataEntryWriter writer = DataEntryWriterFactory.createDataEntryWriter(classPath, fromOutputIndex, toOutputIndex);
            ClassRewriter classRewriter = new ClassRewriter(programClassPool, writer);
            DataEntryReader resourceRewriter = new DataEntryCopier(writer);
            if (this.configuration.adaptResourceFileContents != null) {
                adaptedResourceRewriter = new DataEntryRewriter(programClassPool, writer);
                DataEntryReader dataEntryReader = resourceRewriter = this.configuration.adaptResourceFileContents.size() > 0 ? new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(this.configuration.adaptResourceFileContents)), adaptedResourceRewriter, resourceRewriter) : adaptedResourceRewriter;
            }
            if (this.configuration.adaptResourceFileNames != null) {
                adaptedResourceRewriter = new DataEntryRenamer(programClassPool, resourceRewriter);
                resourceRewriter = this.configuration.adaptResourceFileNames.size() > 0 ? new FilteredDataEntryReader(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(this.configuration.adaptResourceFileNames)), adaptedResourceRewriter, resourceRewriter) : adaptedResourceRewriter;
            }
            ClassFilter reader = new ClassFilter(classRewriter, resourceRewriter);
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, fromInputIndex, fromOutputIndex, reader);
            writer.close();
        }
        catch (IOException ex) {
            throw new IOException("Can't write [" + classPath.get(fromOutputIndex).getName() + "] (" + ex.getMessage() + ")");
        }
    }
}

