/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class LibraryClass
implements Clazz {
    public int u2accessFlags;
    public String thisClassName;
    public String superClassName;
    public String[] interfaceNames;
    public LibraryField[] fields;
    public LibraryMethod[] methods;
    public Clazz superClass;
    public Clazz[] interfaceClasses;
    public Clazz[] subClasses;
    public Object visitorInfo;

    boolean isVisible() {
        return (this.u2accessFlags & 1) != 0;
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName() {
        return this.thisClassName;
    }

    public String getSuperName() {
        return this.superClassName;
    }

    public int getInterfaceCount() {
        return this.interfaceClasses.length;
    }

    public String getInterfaceName(int index) {
        return this.interfaceNames[index];
    }

    public int getTag(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getString(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getStringString(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getClassName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getName(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public String getType(int constantIndex) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store constant pool");
    }

    public void addSubClass(Clazz clazz) {
        if (this.subClasses == null) {
            this.subClasses = new Clazz[1];
        } else {
            Clazz[] temp = new Clazz[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, temp, 0, this.subClasses.length);
            this.subClasses = temp;
        }
        this.subClasses[this.subClasses.length - 1] = clazz;
    }

    public Clazz getSuperClass() {
        return this.superClass;
    }

    public Clazz getInterface(int index) {
        return this.interfaceClasses[index];
    }

    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        return this.superClass != null && this.superClass.extends_(clazz);
    }

    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        if (this.superClass != null && this.superClass.extendsOrImplements(clazz)) {
            return true;
        }
        if (this.interfaceClasses != null) {
            for (int index = 0; index < this.interfaceClasses.length; ++index) {
                Clazz interfaceClass = this.interfaceClasses[index];
                if (interfaceClass == null || !interfaceClass.extendsOrImplements(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public Field findField(String name, String descriptor) {
        for (int index = 0; index < this.fields.length; ++index) {
            LibraryField field = this.fields[index];
            if (field == null || name != null && !field.getName(this).equals(name) || descriptor != null && !field.getDescriptor(this).equals(descriptor)) continue;
            return field;
        }
        return null;
    }

    public Method findMethod(String name, String descriptor) {
        for (int index = 0; index < this.methods.length; ++index) {
            LibraryMethod method = this.methods[index];
            if (method == null || name != null && !method.getName(this).equals(name) || descriptor != null && !method.getDescriptor(this).equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitLibraryClass(this);
    }

    public void hierarchyAccept(boolean visitThisClass, boolean visitSuperClass, boolean visitInterfaces, boolean visitSubclasses, ClassVisitor classVisitor) {
        int index;
        if (visitThisClass) {
            this.accept(classVisitor);
        }
        if (visitSuperClass && this.superClass != null) {
            this.superClass.hierarchyAccept(true, true, visitInterfaces, false, classVisitor);
        }
        if (visitInterfaces && this.interfaceClasses != null) {
            for (index = 0; index < this.interfaceClasses.length; ++index) {
                Clazz interfaceClass = this.interfaceClasses[index];
                if (interfaceClass == null) continue;
                interfaceClass.hierarchyAccept(true, true, true, false, classVisitor);
            }
        }
        if (visitSubclasses && this.subClasses != null) {
            for (index = 0; index < this.subClasses.length; ++index) {
                this.subClasses[index].hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
    }

    public void constantPoolEntryAccept(int index, ConstantVisitor constantVisitor) {
    }

    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.fields.length; ++index) {
            LibraryField field = this.fields[index];
            if (field == null) continue;
            field.accept((Clazz)this, memberVisitor);
        }
    }

    public void fieldAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Field field = this.findField(name, descriptor);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.methods.length; ++index) {
            LibraryMethod method = this.methods[index];
            if (method == null) continue;
            method.accept((Clazz)this, memberVisitor);
        }
    }

    public void methodAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Method method = this.findMethod(name, descriptor);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    private boolean isSpecial(Method method) {
        return (method.getAccessFlags() & 0xA) != 0 || method.getName(this).equals("<init>");
    }

    public void methodImplementationsAccept(Method method, boolean visitThisMethod, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(method.getName(this), method.getDescriptor(this), method, visitThisMethod, true, true, true, memberVisitor);
    }

    public void methodImplementationsAccept(String name, String descriptor, boolean visitThisMethod, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(name, descriptor, visitThisMethod, true, true, true, memberVisitor);
    }

    public void methodImplementationsAccept(String name, String descriptor, boolean visitThisMethod, boolean visitSpecialMethods, boolean visitSuperMethods, boolean visitOverridingMethods, MemberVisitor memberVisitor) {
        this.methodImplementationsAccept(name, descriptor, this.findMethod(name, descriptor), visitThisMethod, visitSpecialMethods, visitSuperMethods, visitOverridingMethods, memberVisitor);
    }

    public void methodImplementationsAccept(String name, String descriptor, Method method, boolean visitThisMethod, boolean visitSpecialMethods, boolean visitSuperMethods, boolean visitOverridingMethods, MemberVisitor memberVisitor) {
        if (method != null) {
            if (this.isSpecial(method)) {
                if (visitSpecialMethods) {
                    method.accept(this, memberVisitor);
                    return;
                }
            } else {
                if (visitThisMethod) {
                    method.accept(this, memberVisitor);
                }
                if (!this.mayHaveImplementations(method)) {
                    visitOverridingMethods = false;
                }
                if ((method.getAccessFlags() & 0x400) == 0) {
                    visitSuperMethods = false;
                }
            }
        }
        if (visitOverridingMethods) {
            if (this.subClasses != null) {
                for (int index = 0; index < this.subClasses.length; ++index) {
                    Clazz subClass = this.subClasses[index];
                    subClass.methodImplementationsAccept(name, descriptor, true, false, visitSuperMethods, true, memberVisitor);
                }
            }
            if ((this.u2accessFlags & 0x600) != 0) {
                visitSuperMethods = false;
            }
        }
        if (visitSuperMethods && this.superClass != null) {
            this.superClass.methodImplementationsAccept(name, descriptor, true, false, true, false, memberVisitor);
        }
    }

    public void attributesAccept(AttributeVisitor attributeVisitor) {
        throw new UnsupportedOperationException("Library class [" + this.thisClassName + "] doesn't store attributes");
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object visitorInfo) {
        this.visitorInfo = visitorInfo;
    }
}

