/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;

public class LineNumberTableAttribute
extends Attribute {
    public int u2lineNumberTableLength;
    public LineNumberInfo[] lineNumberTable;

    public int getLineNumber(int pc) {
        for (int index = this.u2lineNumberTableLength - 1; index >= 0; --index) {
            LineNumberInfo info = this.lineNumberTable[index];
            if (pc < info.u2startPC) continue;
            return info.u2lineNumber;
        }
        return this.u2lineNumberTableLength > 0 ? this.lineNumberTable[0].u2lineNumber : 0;
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, AttributeVisitor attributeVisitor) {
        attributeVisitor.visitLineNumberTableAttribute(clazz, method, codeAttribute, this);
    }

    public void lineNumbersAccept(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfoVisitor lineNumberInfoVisitor) {
        for (int index = 0; index < this.u2lineNumberTableLength; ++index) {
            lineNumberInfoVisitor.visitLineNumberInfo(clazz, method, codeAttribute, this.lineNumberTable[index]);
        }
    }
}

