/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;

public class AttributesEditor {
    public void addAttribute(ProgramClass programClass, Attribute attribute) {
        if (!this.replaceAttribute(programClass, programClass.u2attributesCount, programClass.attributes, attribute)) {
            programClass.attributes = this.appendAttribute(programClass.u2attributesCount, programClass.attributes, attribute);
            ++programClass.u2attributesCount;
        }
    }

    public void addAttribute(ProgramClass programClass, ProgramField programField, Attribute attribute) {
        if (!this.replaceAttribute(programClass, programField.u2attributesCount, programField.attributes, attribute)) {
            programField.attributes = this.appendAttribute(programField.u2attributesCount, programField.attributes, attribute);
            ++programField.u2attributesCount;
        }
    }

    public void addAttribute(ProgramClass programClass, ProgramMethod programMethod, Attribute attribute) {
        if (!this.replaceAttribute(programClass, programMethod.u2attributesCount, programMethod.attributes, attribute)) {
            programMethod.attributes = this.appendAttribute(programMethod.u2attributesCount, programMethod.attributes, attribute);
            ++programMethod.u2attributesCount;
        }
    }

    public void addAttribute(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, Attribute attribute) {
        if (!this.replaceAttribute(programClass, codeAttribute.u2attributesCount, codeAttribute.attributes, attribute)) {
            codeAttribute.attributes = this.appendAttribute(codeAttribute.u2attributesCount, codeAttribute.attributes, attribute);
            ++codeAttribute.u2attributesCount;
        }
    }

    public void deleteAttribute(ProgramClass programClass, String attributeName) {
        programClass.u2attributesCount = this.deleteAttribute((Clazz)programClass, programClass.u2attributesCount, programClass.attributes, attributeName);
    }

    public void deleteAttribute(ProgramClass programClass, ProgramField programField, String attributeName) {
        programField.u2attributesCount = this.deleteAttribute((Clazz)programClass, programField.u2attributesCount, programField.attributes, attributeName);
    }

    public void deleteAttribute(ProgramClass programClass, ProgramMethod programMethod, String attributeName) {
        programMethod.u2attributesCount = this.deleteAttribute((Clazz)programClass, programMethod.u2attributesCount, programMethod.attributes, attributeName);
    }

    public void deleteAttribute(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, String attributeName) {
        codeAttribute.u2attributesCount = this.deleteAttribute((Clazz)programClass, codeAttribute.u2attributesCount, codeAttribute.attributes, attributeName);
    }

    private boolean replaceAttribute(Clazz clazz, int attributesCount, Attribute[] attributes, Attribute attribute) {
        String attributeName = attribute.getAttributeName(clazz);
        for (int index = 0; index < attributesCount; ++index) {
            if (!attributes[index].getAttributeName(clazz).equals(attributeName)) continue;
            attributes[index] = attribute;
            return true;
        }
        return false;
    }

    private Attribute[] appendAttribute(int attributesCount, Attribute[] attributes, Attribute attribute) {
        if (attributes.length <= attributesCount) {
            Attribute[] newAttributes = new Attribute[attributesCount + 1];
            System.arraycopy(attributes, 0, newAttributes, 0, attributesCount);
            attributes = newAttributes;
        }
        attributes[attributesCount] = attribute;
        return attributes;
    }

    private int deleteAttribute(Clazz clazz, int attributesCount, Attribute[] attributes, String attributeName) {
        int index;
        int newIndex = 0;
        for (index = 0; index < attributesCount; ++index) {
            if (attributes[index].getAttributeName(clazz).equals(attributeName)) continue;
            attributes[newIndex++] = attributes[index];
        }
        for (index = newIndex; index < attributesCount; ++index) {
            attributes[index] = null;
        }
        return newIndex;
    }
}

