/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.UninitializedType;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.editor.InstructionWriter;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableSizeUpdater;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class CodeAttributeEditor
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
LineNumberInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private boolean updateFrameSizes;
    private int codeLength;
    private boolean modified;
    private boolean simple;
    public Instruction[] preInsertions = new Instruction[1024];
    public Instruction[] replacements = new Instruction[1024];
    public Instruction[] postInsertions = new Instruction[1024];
    public boolean[] deleted = new boolean[1024];
    private int[] instructionOffsetMap = new int[1024];
    private int newOffset;
    private boolean lengthIncreased;
    private int expectedStackMapFrameOffset;
    private final StackSizeUpdater stackSizeUpdater = new StackSizeUpdater();
    private final VariableSizeUpdater variableSizeUpdater = new VariableSizeUpdater();
    private final InstructionWriter instructionWriter = new InstructionWriter();

    public CodeAttributeEditor() {
        this(true);
    }

    public CodeAttributeEditor(boolean updateFrameSizes) {
        this.updateFrameSizes = updateFrameSizes;
    }

    public void reset(int codeLength) {
        this.codeLength = codeLength;
        if (this.preInsertions.length < codeLength) {
            this.preInsertions = new Instruction[codeLength];
            this.replacements = new Instruction[codeLength];
            this.postInsertions = new Instruction[codeLength];
            this.deleted = new boolean[codeLength];
        } else {
            for (int index = 0; index < codeLength; ++index) {
                this.preInsertions[index] = null;
                this.replacements[index] = null;
                this.postInsertions[index] = null;
                this.deleted[index] = false;
            }
        }
        this.modified = false;
        this.simple = true;
    }

    public void insertBeforeInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.preInsertions[instructionOffset] = instruction;
        this.modified = true;
        this.simple = false;
    }

    public void replaceInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.replacements[instructionOffset] = instruction;
        this.modified = true;
    }

    public void insertAfterInstruction(int instructionOffset, Instruction instruction) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.postInsertions[instructionOffset] = instruction;
        this.modified = true;
        this.simple = false;
    }

    public void deleteInstruction(int instructionOffset) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[instructionOffset] = true;
        this.modified = true;
        this.simple = false;
    }

    public void undeleteInstruction(int instructionOffset) {
        if (instructionOffset < 0 || instructionOffset >= this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + instructionOffset + "] in code with length [" + this.codeLength + "]");
        }
        this.deleted[instructionOffset] = false;
    }

    public boolean isModified(int instructionOffset) {
        return this.preInsertions[instructionOffset] != null || this.replacements[instructionOffset] != null || this.postInsertions[instructionOffset] != null || this.deleted[instructionOffset];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while editing code:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.modified) {
            return;
        }
        if (this.canPerformSimpleReplacements(codeAttribute)) {
            this.performSimpleReplacements(codeAttribute);
            this.updateFrameSizes(clazz, method, codeAttribute);
        } else {
            codeAttribute.u4codeLength = this.updateInstructions(clazz, method, codeAttribute);
            codeAttribute.exceptionsAccept(clazz, method, this);
            codeAttribute.u2exceptionTableLength = this.removeEmptyExceptions(codeAttribute.exceptionTable, codeAttribute.u2exceptionTableLength);
            this.updateFrameSizes(clazz, method, codeAttribute);
            codeAttribute.attributesAccept(clazz, method, this);
            this.instructionWriter.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private void updateFrameSizes(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.updateFrameSizes) {
            this.stackSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
            this.variableSizeUpdater.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.expectedStackMapFrameOffset = -1;
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.expectedStackMapFrameOffset = 0;
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
        lineNumberTableAttribute.u2lineNumberTableLength = this.removeEmptyLineNumbers(lineNumberTableAttribute.lineNumberTable, lineNumberTableAttribute.u2lineNumberTableLength, codeAttribute.u4codeLength);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTableAttribute.u2localVariableTableLength = this.removeEmptyLocalVariables(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength, codeAttribute.u2maxLocals);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.removeEmptyLocalVariableTypes(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength, codeAttribute.u2maxLocals);
    }

    private boolean canPerformSimpleReplacements(CodeAttribute codeAttribute) {
        if (!this.simple) {
            return false;
        }
        byte[] code = codeAttribute.code;
        int codeLength = codeAttribute.u4codeLength;
        for (int offset = 0; offset < codeLength; ++offset) {
            Instruction replacementInstruction = this.replacements[offset];
            if (replacementInstruction == null || replacementInstruction.length(offset) == InstructionFactory.create(code, offset).length(offset)) continue;
            return false;
        }
        return true;
    }

    private void performSimpleReplacements(CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        for (int offset = 0; offset < codeLength; ++offset) {
            Instruction replacementInstruction = this.replacements[offset];
            if (replacementInstruction == null) continue;
            replacementInstruction.write(codeAttribute, offset);
        }
    }

    private int updateInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        byte[] oldCode = codeAttribute.code;
        int oldLength = codeAttribute.u4codeLength;
        if (this.instructionOffsetMap.length < oldLength + 1) {
            this.instructionOffsetMap = new int[oldLength + 1];
        }
        int newLength = this.mapInstructions(oldCode, oldLength);
        if (this.lengthIncreased) {
            codeAttribute.code = new byte[newLength];
        }
        this.instructionWriter.reset(newLength);
        this.moveInstructions(clazz, method, codeAttribute, oldCode, oldLength);
        return newLength;
    }

    private int mapInstructions(byte[] oldCode, int oldLength) {
        this.newOffset = 0;
        this.lengthIncreased = false;
        int oldOffset = 0;
        do {
            Instruction instruction = InstructionFactory.create(oldCode, oldOffset);
            this.mapInstruction(oldOffset, instruction);
            oldOffset += instruction.length(oldOffset);
            if (this.newOffset <= oldOffset) continue;
            this.lengthIncreased = true;
        } while (oldOffset < oldLength);
        this.instructionOffsetMap[oldOffset] = this.newOffset;
        return this.newOffset;
    }

    private void mapInstruction(int oldOffset, Instruction instruction) {
        Instruction replacementInstruction;
        this.instructionOffsetMap[oldOffset] = this.newOffset;
        Instruction preInstruction = this.preInsertions[oldOffset];
        if (preInstruction != null) {
            this.newOffset += preInstruction.length(this.newOffset);
        }
        if ((replacementInstruction = this.replacements[oldOffset]) != null) {
            this.newOffset += replacementInstruction.length(this.newOffset);
        } else if (!this.deleted[oldOffset]) {
            this.newOffset += instruction.length(this.newOffset);
        }
        Instruction postInstruction = this.postInsertions[oldOffset];
        if (postInstruction != null) {
            this.newOffset += postInstruction.length(this.newOffset);
        }
    }

    private void moveInstructions(Clazz clazz, Method method, CodeAttribute codeAttribute, byte[] oldCode, int oldLength) {
        Instruction instruction;
        this.newOffset = 0;
        int oldOffset = 0;
        do {
            instruction = InstructionFactory.create(oldCode, oldOffset);
            this.moveInstruction(clazz, method, codeAttribute, oldOffset, instruction);
        } while ((oldOffset += instruction.length(oldOffset)) < oldLength);
    }

    private void moveInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int oldOffset, Instruction instruction) {
        Instruction replacementInstruction;
        Instruction preInstruction = this.preInsertions[oldOffset];
        if (preInstruction != null) {
            preInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
            this.newOffset += preInstruction.length(this.newOffset);
        }
        if ((replacementInstruction = this.replacements[oldOffset]) != null) {
            replacementInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
            this.newOffset += replacementInstruction.length(this.newOffset);
        } else if (!this.deleted[oldOffset]) {
            instruction.accept(clazz, method, codeAttribute, oldOffset, this);
            this.newOffset += instruction.length(this.newOffset);
        }
        Instruction postInstruction = this.postInsertions[oldOffset];
        if (postInstruction != null) {
            postInstruction.accept(clazz, method, codeAttribute, oldOffset, this);
            this.newOffset += postInstruction.length(this.newOffset);
        }
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        this.instructionWriter.visitSimpleInstruction(clazz, method, codeAttribute, this.newOffset, simpleInstruction);
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.instructionWriter.visitConstantInstruction(clazz, method, codeAttribute, this.newOffset, constantInstruction);
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        this.instructionWriter.visitVariableInstruction(clazz, method, codeAttribute, this.newOffset, variableInstruction);
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        branchInstruction.branchOffset = this.remapBranchOffset(offset, branchInstruction.branchOffset);
        this.instructionWriter.visitBranchInstruction(clazz, method, codeAttribute, this.newOffset, branchInstruction);
    }

    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
        tableSwitchInstruction.defaultOffset = this.remapBranchOffset(offset, tableSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(offset, tableSwitchInstruction.jumpOffsets);
        this.instructionWriter.visitTableSwitchInstruction(clazz, method, codeAttribute, this.newOffset, tableSwitchInstruction);
    }

    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
        lookUpSwitchInstruction.defaultOffset = this.remapBranchOffset(offset, lookUpSwitchInstruction.defaultOffset);
        this.remapJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets);
        this.instructionWriter.visitLookUpSwitchInstruction(clazz, method, codeAttribute, this.newOffset, lookUpSwitchInstruction);
    }

    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        exceptionInfo.u2startPC = this.remapInstructionOffset(exceptionInfo.u2startPC);
        exceptionInfo.u2endPC = this.remapInstructionOffset(exceptionInfo.u2endPC);
        exceptionInfo.u2handlerPC = this.remapInstructionOffset(exceptionInfo.u2handlerPC);
    }

    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
        int stackMapFrameOffset;
        int offsetDelta = stackMapFrameOffset = this.remapInstructionOffset(offset);
        if (this.expectedStackMapFrameOffset >= 0) {
            offsetDelta -= this.expectedStackMapFrameOffset;
            this.expectedStackMapFrameOffset = stackMapFrameOffset + 1;
        }
        stackMapFrame.u2offsetDelta = offsetDelta;
    }

    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, sameOneFrame);
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, moreZeroFrame);
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        this.visitAnyStackMapFrame(clazz, method, codeAttribute, offset, fullFrame);
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    public void visitUninitializedType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, UninitializedType uninitializedType) {
        uninitializedType.u2newInstructionOffset = this.remapInstructionOffset(uninitializedType.u2newInstructionOffset);
    }

    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        lineNumberInfo.u2startPC = this.remapInstructionOffset(lineNumberInfo.u2startPC);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2length = this.remapBranchOffset(localVariableInfo.u2startPC, localVariableInfo.u2length);
        localVariableInfo.u2startPC = this.remapInstructionOffset(localVariableInfo.u2startPC);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2length = this.remapBranchOffset(localVariableTypeInfo.u2startPC, localVariableTypeInfo.u2length);
        localVariableTypeInfo.u2startPC = this.remapInstructionOffset(localVariableTypeInfo.u2startPC);
    }

    private void remapJumpOffsets(int offset, int[] jumpOffsets) {
        for (int index = 0; index < jumpOffsets.length; ++index) {
            jumpOffsets[index] = this.remapBranchOffset(offset, jumpOffsets[index]);
        }
    }

    private int remapBranchOffset(int offset, int branchOffset) {
        return this.remapInstructionOffset(offset + branchOffset) - this.newOffset;
    }

    private int remapInstructionOffset(int offset) {
        if (offset < 0 || offset > this.codeLength) {
            throw new IllegalArgumentException("Invalid instruction offset [" + offset + "] in code with length [" + this.codeLength + "]");
        }
        return this.instructionOffsetMap[offset];
    }

    private int removeEmptyExceptions(ExceptionInfo[] exceptionInfos, int exceptionInfoCount) {
        int newIndex = 0;
        for (int index = 0; index < exceptionInfoCount; ++index) {
            ExceptionInfo exceptionInfo = exceptionInfos[index];
            if (exceptionInfo.u2startPC >= exceptionInfo.u2endPC) continue;
            exceptionInfos[newIndex++] = exceptionInfo;
        }
        return newIndex;
    }

    private int removeEmptyLineNumbers(LineNumberInfo[] lineNumberInfos, int lineNumberInfoCount, int codeLength) {
        int newIndex = 0;
        for (int index = 0; index < lineNumberInfoCount; ++index) {
            LineNumberInfo lineNumberInfo = lineNumberInfos[index];
            int startPC = lineNumberInfo.u2startPC;
            if (startPC >= codeLength || index != 0 && startPC <= lineNumberInfos[index - 1].u2startPC) continue;
            lineNumberInfos[newIndex++] = lineNumberInfo;
        }
        return newIndex;
    }

    private int removeEmptyLocalVariables(LocalVariableInfo[] localVariableInfos, int localVariableInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableInfoCount; ++index) {
            LocalVariableInfo localVariableInfo = localVariableInfos[index];
            if (localVariableInfo.u2length <= 0 || localVariableInfo.u2index >= maxLocals) continue;
            localVariableInfos[newIndex++] = localVariableInfo;
        }
        return newIndex;
    }

    private int removeEmptyLocalVariableTypes(LocalVariableTypeInfo[] localVariableTypeInfos, int localVariableTypeInfoCount, int maxLocals) {
        int newIndex = 0;
        for (int index = 0; index < localVariableTypeInfoCount; ++index) {
            LocalVariableTypeInfo localVariableTypeInfo = localVariableTypeInfos[index];
            if (localVariableTypeInfo.u2length <= 0 || localVariableTypeInfo.u2index >= maxLocals) continue;
            localVariableTypeInfos[newIndex++] = localVariableTypeInfo;
        }
        return newIndex;
    }
}

