/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

final class ComparableConstant
extends SimplifiedVisitor
implements Comparable,
ConstantVisitor {
    private static final int[] PRIORITIES = new int[13];
    private final Clazz clazz;
    private final int thisIndex;
    private final Constant thisConstant;
    private Constant otherConstant;
    private int result;

    public ComparableConstant(Clazz clazz, int index, Constant constant) {
        this.clazz = clazz;
        this.thisIndex = index;
        this.thisConstant = constant;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public Constant getConstant() {
        return this.thisConstant;
    }

    public int compareTo(Object other) {
        int otherTag;
        ComparableConstant otherComparableConstant = (ComparableConstant)other;
        this.otherConstant = otherComparableConstant.thisConstant;
        if (this.thisConstant == this.otherConstant) {
            int otherIndex = otherComparableConstant.thisIndex;
            return this.thisIndex < otherIndex ? -1 : (this.thisIndex == otherIndex ? 0 : 1);
        }
        int thisTag = this.thisConstant.getTag();
        if (thisTag != (otherTag = this.otherConstant.getTag())) {
            return PRIORITIES[thisTag] < PRIORITIES[otherTag] ? -1 : 1;
        }
        this.thisConstant.accept(this.clazz, this);
        return this.result;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.result = new Integer(integerConstant.getValue()).compareTo(new Integer(((IntegerConstant)this.otherConstant).getValue()));
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.result = new Long(longConstant.getValue()).compareTo(new Long(((LongConstant)this.otherConstant).getValue()));
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.result = new Float(floatConstant.getValue()).compareTo(new Float(((FloatConstant)this.otherConstant).getValue()));
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.result = new Double(doubleConstant.getValue()).compareTo(new Double(((DoubleConstant)this.otherConstant).getValue()));
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.result = stringConstant.getString(clazz).compareTo(((StringConstant)this.otherConstant).getString(clazz));
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.result = utf8Constant.getString().compareTo(((Utf8Constant)this.otherConstant).getString());
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant otherRefConstant = (RefConstant)this.otherConstant;
        this.result = (refConstant.getClassName(clazz) + ' ' + refConstant.getName(clazz) + ' ' + refConstant.getType(clazz)).compareTo(otherRefConstant.getClassName(clazz) + ' ' + otherRefConstant.getName(clazz) + ' ' + otherRefConstant.getType(clazz));
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.result = classConstant.getName(clazz).compareTo(((ClassConstant)this.otherConstant).getName(clazz));
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant otherNameAndTypeConstant = (NameAndTypeConstant)this.otherConstant;
        this.result = (nameAndTypeConstant.getName(clazz) + ' ' + nameAndTypeConstant.getType(clazz)).compareTo(otherNameAndTypeConstant.getName(clazz) + ' ' + otherNameAndTypeConstant.getType(clazz));
    }

    static {
        ComparableConstant.PRIORITIES[3] = 0;
        ComparableConstant.PRIORITIES[4] = 1;
        ComparableConstant.PRIORITIES[5] = 2;
        ComparableConstant.PRIORITIES[6] = 3;
        ComparableConstant.PRIORITIES[8] = 4;
        ComparableConstant.PRIORITIES[7] = 5;
        ComparableConstant.PRIORITIES[9] = 6;
        ComparableConstant.PRIORITIES[10] = 7;
        ComparableConstant.PRIORITIES[11] = 8;
        ComparableConstant.PRIORITIES[12] = 9;
        ComparableConstant.PRIORITIES[1] = 10;
    }
}

