/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;

public class ConstantPoolEditor {
    private static final boolean DEBUG = false;

    public int addIntegerConstant(ProgramClass programClass, int value) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            IntegerConstant integerConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 3 || (integerConstant = (IntegerConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(programClass, new IntegerConstant(value));
    }

    public int addLongConstant(ProgramClass programClass, long value) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            LongConstant longConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 5 || (longConstant = (LongConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(programClass, new LongConstant(value));
    }

    public int addFloatConstant(ProgramClass programClass, float value) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            FloatConstant floatConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 4 || (floatConstant = (FloatConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(programClass, new FloatConstant(value));
    }

    public int addDoubleConstant(ProgramClass programClass, double value) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            DoubleConstant doubleConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 6 || (doubleConstant = (DoubleConstant)constant).getValue() != value) continue;
            return index;
        }
        return this.addConstant(programClass, new DoubleConstant(value));
    }

    public int addStringConstant(ProgramClass programClass, String string, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            StringConstant classConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 8 || !(classConstant = (StringConstant)constant).getString(programClass).equals(string)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(programClass, string);
        return this.addConstant(programClass, new StringConstant(nameIndex, referencedClass, referencedMember));
    }

    public int addFieldrefConstant(ProgramClass programClass, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(programClass, referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(ProgramClass programClass, String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(programClass, className, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(ProgramClass programClass, String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(programClass, this.addClassConstant(programClass, className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addFieldrefConstant(ProgramClass programClass, int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addFieldrefConstant(programClass, classIndex, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addFieldrefConstant(ProgramClass programClass, int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 9) continue;
            FieldrefConstant fieldrefConstant = (FieldrefConstant)constant;
            if (fieldrefConstant.u2classIndex != classIndex || fieldrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(programClass, new FieldrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addInterfaceMethodrefConstant(ProgramClass programClass, String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(programClass, className, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(ProgramClass programClass, String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(programClass, this.addClassConstant(programClass, className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(ProgramClass programClass, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(programClass, referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(ProgramClass programClass, int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addInterfaceMethodrefConstant(programClass, classIndex, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addInterfaceMethodrefConstant(ProgramClass programClass, int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 11) continue;
            InterfaceMethodrefConstant methodrefConstant = (InterfaceMethodrefConstant)constant;
            if (methodrefConstant.u2classIndex != classIndex || methodrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(programClass, new InterfaceMethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addMethodrefConstant(ProgramClass programClass, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(programClass, referencedClass.getName(), referencedMember.getName(referencedClass), referencedMember.getDescriptor(referencedClass), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(ProgramClass programClass, String className, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(programClass, className, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(ProgramClass programClass, String className, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(programClass, this.addClassConstant(programClass, className, referencedClass), nameAndTypeIndex, referencedClass, referencedMember);
    }

    public int addMethodrefConstant(ProgramClass programClass, int classIndex, String name, String descriptor, Clazz referencedClass, Member referencedMember) {
        return this.addMethodrefConstant(programClass, classIndex, this.addNameAndTypeConstant(programClass, name, descriptor), referencedClass, referencedMember);
    }

    public int addMethodrefConstant(ProgramClass programClass, int classIndex, int nameAndTypeIndex, Clazz referencedClass, Member referencedMember) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 10) continue;
            MethodrefConstant methodrefConstant = (MethodrefConstant)constant;
            if (methodrefConstant.u2classIndex != classIndex || methodrefConstant.u2nameAndTypeIndex != nameAndTypeIndex) continue;
            return index;
        }
        return this.addConstant(programClass, new MethodrefConstant(classIndex, nameAndTypeIndex, referencedClass, referencedMember));
    }

    public int addClassConstant(ProgramClass programClass, Clazz referencedClass) {
        return this.addClassConstant(programClass, referencedClass.getName(), referencedClass);
    }

    public int addClassConstant(ProgramClass programClass, String name, Clazz referencedClass) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            ClassConstant classConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 7 || !(classConstant = (ClassConstant)constant).getName(programClass).equals(name)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(programClass, name);
        return this.addConstant(programClass, new ClassConstant(nameIndex, referencedClass));
    }

    public int addNameAndTypeConstant(ProgramClass programClass, String name, String type) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            NameAndTypeConstant nameAndTypeConstant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 12 || !(nameAndTypeConstant = (NameAndTypeConstant)constant).getName(programClass).equals(name) || !nameAndTypeConstant.getType(programClass).equals(type)) continue;
            return index;
        }
        int nameIndex = this.addUtf8Constant(programClass, name);
        int descriptorIndex = this.addUtf8Constant(programClass, type);
        return this.addConstant(programClass, new NameAndTypeConstant(nameIndex, descriptorIndex));
    }

    public int addUtf8Constant(ProgramClass programClass, String string) {
        int constantPoolCount = programClass.u2constantPoolCount;
        Constant[] constantPool = programClass.constantPool;
        for (int index = 1; index < constantPoolCount; ++index) {
            Utf8Constant utf8Constant;
            Constant constant = constantPool[index];
            if (constant == null || constant.getTag() != 1 || !(utf8Constant = (Utf8Constant)constant).getString().equals(string)) continue;
            return index;
        }
        return this.addConstant(programClass, new Utf8Constant(string));
    }

    public int addConstant(ProgramClass programClass, Constant constant) {
        Constant[] constantPool = programClass.constantPool;
        int constantPoolCount = programClass.u2constantPoolCount;
        if (constantPool.length < constantPoolCount + 2) {
            programClass.constantPool = new Constant[constantPoolCount + 2];
            System.arraycopy(constantPool, 0, programClass.constantPool, 0, constantPoolCount);
            constantPool = programClass.constantPool;
        }
        constantPool[programClass.u2constantPoolCount++] = constant;
        int tag = constant.getTag();
        if (tag == 5 || tag == 6) {
            constantPool[programClass.u2constantPoolCount++] = null;
        }
        return constantPoolCount;
    }
}

