/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ComparableConstant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassVisitor;

public class ConstantPoolSorter
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private ComparableConstant[] comparableConstantPool = new ComparableConstant[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        this.sortConstantPool(programClass, programClass.constantPool, programClass.u2constantPoolCount);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private void sortConstantPool(Clazz clazz, Constant[] constantPool, int length) {
        if (this.constantIndexMap.length < length) {
            this.constantIndexMap = new int[length];
            this.comparableConstantPool = new ComparableConstant[length];
        }
        for (int oldIndex = 1; oldIndex < length; ++oldIndex) {
            Constant constant = constantPool[oldIndex];
            if (constant == null) {
                constant = constantPool[oldIndex - 1];
            }
            this.comparableConstantPool[oldIndex] = new ComparableConstant(clazz, oldIndex, constant);
        }
        Arrays.sort(this.comparableConstantPool, 1, length);
        Constant previousConstant = null;
        for (int newIndex = 1; newIndex < length; ++newIndex) {
            ComparableConstant comparableConstant = this.comparableConstantPool[newIndex];
            int oldIndex = comparableConstant.getIndex();
            this.constantIndexMap[oldIndex] = newIndex;
            Constant constant = comparableConstant.getConstant();
            constantPool[newIndex] = constant != previousConstant ? constant : null;
            previousConstant = constant;
        }
    }
}

