/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.MembersEditor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAdder
extends SimplifiedVisitor
implements MemberVisitor {
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final ProgramClass targetClass;
    private final boolean copyAttributes;
    private final ConstantAdder constantAdder = new ConstantAdder();
    private final MembersEditor membersEditor = new MembersEditor();

    public MemberAdder(ProgramClass targetClass, boolean copyAttributes) {
        this.targetClass = targetClass;
        this.copyAttributes = copyAttributes;
        this.constantAdder.setTargetClass(targetClass);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String descriptor;
        String name = programField.getName(programClass);
        if (this.targetClass.findMethod(name, descriptor = programField.getDescriptor(programClass)) == null) {
            ProgramField newProgramField = new ProgramField();
            newProgramField.u2accessFlags = programField.u2accessFlags;
            programClass.constantPoolEntryAccept(programField.u2nameIndex, this.constantAdder);
            newProgramField.u2nameIndex = this.constantAdder.getConstantIndex();
            programClass.constantPoolEntryAccept(programField.u2descriptorIndex, this.constantAdder);
            newProgramField.u2descriptorIndex = this.constantAdder.getConstantIndex();
            if (this.copyAttributes) {
                programField.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramField));
            }
            this.membersEditor.addField(this.targetClass, newProgramField);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String descriptor;
        String name = programMethod.getName(programClass);
        if (this.targetClass.findMethod(name, descriptor = programMethod.getDescriptor(programClass)) == null) {
            ProgramMethod newProgramMethod = new ProgramMethod();
            newProgramMethod.u2accessFlags = programMethod.u2accessFlags;
            programClass.constantPoolEntryAccept(programMethod.u2nameIndex, this.constantAdder);
            newProgramMethod.u2nameIndex = this.constantAdder.getConstantIndex();
            programClass.constantPoolEntryAccept(programMethod.u2descriptorIndex, this.constantAdder);
            newProgramMethod.u2descriptorIndex = this.constantAdder.getConstantIndex();
            newProgramMethod.u2attributesCount = 0;
            newProgramMethod.attributes = EMPTY_ATTRIBUTES;
            if (this.copyAttributes) {
                programMethod.attributesAccept(programClass, new AttributeAdder(this.targetClass, newProgramMethod));
            }
            this.membersEditor.addMethod(this.targetClass, newProgramMethod);
        }
    }
}

